% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_goodness_poly.R
\name{model_goodness_for_algo_poly}
\alias{model_goodness_for_algo_poly}
\title{Computes the goodness of the IRT model fit for a given algorithm.}
\usage{
model_goodness_for_algo_poly(mod, num = 1)
}
\arguments{
\item{mod}{A fitted \code{mirt} model using the function \code{irtmodel} or \code{R} package \code{mirt}.}

\item{num}{The algorithm number}
}
\value{
A list with the following components:
\item{\code{xy}}{The \code{x} values denote the error tolerances. The \code{y} values denotes its empirical cumulative distribution function. }
\item{\code{auc}}{The area under the CDF. }
\item{\code{mse}}{The mean squared error. }
}
\description{
This function computes the goodness of the IRT model fit for a given algorithm using the empirical cumulative distribution function of errors.
}
\examples{
set.seed(1)
x1 <- sample(1:5, 100, replace = TRUE)
x2 <- sample(1:5, 100, replace = TRUE)
x3 <- sample(1:5, 100, replace = TRUE)
X <- cbind.data.frame(x1, x2, x3)
mod <- pirtmodel(X)
out <- model_goodness_for_algo_poly(mod$model, num=1)
out

}
