% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{kappa4Int}
\alias{kappa4Int}
\alias{kappa4Int2}
\title{Arc length of four-parameter kappa CDF.}
\usage{
kappa4Int(mu, sigma, h, k, tau, q1, q2, quantile)

kappa4Int2(mu, sigma, h, k, tau, q1, q2, quantile)
}
\arguments{
\item{mu}{A real number specifying the location parameter.}

\item{sigma}{A positive real number specifying the scale parameter.}

\item{h, k}{Real numbers specifying the two shape parameters.}

\item{tau}{A real number between 0 and 1, corresponding to the CDF value at the point of truncation.}

\item{q1}{The point (or vector for \code{kappa4Int2}) specifying the lower limit of the arc length integral.}

\item{q2}{The point (or vector for \code{kappa4Int2}) specifying the upper limit of the arc length integral.}

\item{quantile}{Logical, TRUE/FALSE, whether \code{q1} and \code{q2} are quantiles, or actual points in the domain.}
}
\value{
kappa4Int: A list with the following components:
\itemize{
\item value: The resultant arc length.
\item abs.err: The absolute error between iterations.
subdivisions: Number of subdivisions used in the numerical approximation.
\item neval: Number of function evaluations used by the numerical approximation.
}

kappa4Int2: A vector having length equal to that of the vector of lower quantile bounds, containing the arc lengths requested for a four-parameter kappa cumulative distribution function.
}
\description{
Calculate the arc length for a univariate four-parameter kappa cumulative distribution function over a specified interval.
}
\details{
The arc length of a univariate four-parameter kappa cumulative distribution function is approximated using the numerical integration C code implimented for R's integrate functions, i.e. using Rdqags.  For this approximation, subdiv = 100 (100 subdivisions), and eps_abs = eps_rel = 1e-10, i.e. the absolute and relative errors respectively.
}
\examples{
library(alR)
mu <- 4
sigma <- 0.4
h <- -4
tau <- 1 ## no truncation
k <- kappa4tc(-4, 0, 1)$par
kappa4Int(mu, sigma, h, k, tau, 0.025, 0.975, TRUE)
p1 <- qkappa4(0.025, mu, sigma, h, k)
p2 <- qkappa4(0.975, mu, sigma, h, k)
kappa4Int(mu, sigma, h, k, tau, p1, p2, FALSE)

kappa4Int2(mu, sigma, h, k, tau, c(0.025, 0.5), c(0.5, 0.975), TRUE)
p12 <- qkappa4(0.5, mu, sigma, h, k)
kappa4Int2(mu, sigma, h, k, tau, c(p1, p12), c(p12, p2), FALSE)

}
