% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Data.R
\docType{data}
\name{DEFAULT_COLORS}
\alias{DEFAULT_COLORS}
\alias{DNA_COLORS}
\alias{IG_COLORS}
\alias{TR_COLORS}
\title{Default colors}
\format{Named character vectors with hexcode colors as values.
\itemize{
  \item  \code{DNA_COLORS}:  DNA character colors 
                             \code{c("A", "C", "G", "T")}.
  \item  \code{IG_COLORS}:   Ig isotype colors 
                             \code{c("IgA", "IgD", "IgE", "IgG", "IgM", "IgK", "IgL")}.
  \item  \code{TR_COLORS}:   TCR chain colors 
                             \code{c("TRA", "TRB", "TRD", "TRG")}.
}}
\usage{
DNA_COLORS

IG_COLORS

TR_COLORS
}
\description{
Default color palettes for DNA characters, Ig isotypes, and TCR chains.
}
\examples{
# IG_COLORS as an isotype color set for ggplot
isotype <- c("IgG", "IgM", "IgM", "IgA")
db <- data.frame(x=1:4, y=1:4, iso=isotype)
g1 <- ggplot(db, aes(x=x, y=y, color=iso)) + 
    scale_color_manual(name="Isotype", values=IG_COLORS) +
    geom_point(size=10)
plot(g1)

# DNA_COLORS to translate nucleotide values to a vector of colors 
# for use in base graphics plots
seq <- c("A", "T", "T", "C")
colors <- translateStrings(seq, setNames(names(DNA_COLORS), DNA_COLORS))
plot(1:4, 1:4, col=colors, pch=16, cex=6)

}
\keyword{datasets}

