% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allToAllTraverse.R
\name{vgaIsovist}
\alias{vgaIsovist}
\title{Visibility Graph Analysis - isovist metrics}
\usage{
vgaIsovist(pointMap, boundaryMap, copyMap = TRUE)
}
\arguments{
\item{pointMap}{A PointMap}

\item{boundaryMap}{A ShapeMap of lines}

\item{copyMap}{Optional. Copy the internal sala map}
}
\value{
A new PointMap with the results included
}
\description{
Runs axial analysis to get the local metrics Control and Controllability
}
\examples{
mifFile <- system.file(
    "extdata", "testdata", "simple",
    "simple_interior.mif",
    package = "alcyon"
  )
  sfMap <- st_read(mifFile,
    geometry_column = 1L, quiet = TRUE
  )
  pointMap <- makeVGAPointMap(
    sfMap,
    gridSize = 0.5,
    fillX = 3.0,
    fillY = 6.0,
    maxVisibility = NA,
    boundaryGraph = FALSE,
    verbose = FALSE
  )
boundaryMap <- as(sfMap[, c()], "ShapeMap")
vgaIsovist(pointMap, boundaryMap)
}
