% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/traits_to_mfg.R
\name{traits_to_mfg}
\alias{traits_to_mfg}
\title{Assign a morphofunctional group based on binary functional traits and higher taxonomy}
\usage{
traits_to_mfg(flagella = NA, size = NA, colonial = NA,
  filament = NA, centric = NA, gelatinous = NA, aerotopes = NA,
  class = NA, order = NA)
}
\arguments{
\item{flagella}{1 if flagella are present, 0 if they are absent.}

\item{size}{Character string: 'large' or 'small'. Classification criteria is left to the user.}

\item{colonial}{1 if typically colonial growth form, 0 if typically unicellular.}

\item{filament}{1 if dominant growth form is filamentous, 0 if not.}

\item{centric}{1 if diatom with centric growth form, 0 if not. NA for  non-diatoms.}

\item{gelatinous}{1 mucilagenous sheath is typically present, 0 if not.}

\item{aerotopes}{1 if aerotopes allowing buoyancy regulation are typically present, 0 if not.}

\item{class}{Character string: The taxonomic class of the species}

\item{order}{Character string: The taxonomic order of the species}
}
\value{
A character string of the species' morphofunctional group
}
\description{
Assign a morphofunctional group based on binary functional traits and higher taxonomy
}
\examples{
traits_to_mfg(1,"large",1,0,NA,0,0,"Euglenophyceae","Euglenales")

}
\seealso{
\url{http://www.algaebase.org} for up-to-date phytoplankton taxonomy,
    \url{https://powellcenter.usgs.gov/geisha} for project information
}
