% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/algaebase_genus_search.r
\name{algaebase_genus_search}
\alias{algaebase_genus_search}
\title{Search algaebase for information about a genus of phytoplankton}
\usage{
algaebase_genus_search(
  genus = NULL,
  apikey = NULL,
  handle = NULL,
  higher = TRUE,
  print.full.json = FALSE,
  newest.only = TRUE,
  long = FALSE,
  exact.matches.only = TRUE,
  return.higher.only = FALSE,
  api_file = NULL
)
}
\arguments{
\item{genus}{genus name as character string}

\item{apikey}{valid key for algaebase API as character string}

\item{handle}{curl handle with API key. Will be created if not present.}

\item{higher}{boolean should higher taxonomy be included in output?}

\item{print.full.json}{boolean returns raw json output if TRUE. Default is FALSE (return R data frame)}

\item{newest.only}{boolean should results be limited to the most recent matching entry in algaebase?}

\item{long}{boolean return long output including full species name and authorship, and entry date from algaebase.}

\item{exact.matches.only}{boolean should results be limited to exact matches?}

\item{return.higher.only}{boolean should output only included higher taxonomy?}

\item{api_file}{path to text file containing a valid API key}
}
\value{
data frame that may include: accepted.name (currently accepted synonym if different from input name), input.name (name supplied by user), input.match (1 if exact match, else 0), currently.accepted (1=TRUE/0=FALSE), genus.only (1=genus search/0=genus+species search),higher taxonomy (kingdom,phylum,class,order,family), genus, species (always NA for genus search), infraspecies name (always NA for genus search), long.name (includes author and date if given), taxonomic.status (currently accepted, synonym, or unverified), taxon.rank (taxonomic rank of accepted name (genus, species, infraspecies), mod.date (date when entry was last modified in algaebase).
}
\description{
Search algaebase for information about a genus of phytoplankton
}
\examples{
\dontrun{algaebase_genus_search("Anabaena")} #not run.

}
