#' Trait-based MFG classifications for common Eurasion/North American phytoplankton species.
#' See accompanying manuscript for sources
#'
#' @format A data frame with columns:
#' \describe{
#'  \item{genus}{genus name}
#'  \item{species}{species name}
#'  \item{MFG}{corresponding MFG classification based on Salmaso et al. 2015}
#'  \item{source}{literature or online source for MFG classification}
#'  }
#'
#' @docType data
#'
#' @usage data(species_mfg_library)
#'
#' @keywords datasets
#'
#' @references {Algaebase} \url{https://www.algaebase.org}
#' @references {Phycokey} \url{https://www.cfb.unh.edu/phycokey/phycokey.htm}
#' @references {Western Diatoms of North America} \url{https://diatoms.org}
#' @references {CyanoDB 2} \url{http://www.cyanodb.cz/}
#' @references {Nordic Microalgae} \url{https://nordicmicroalgae.org}
#' @references {Phytopedia} \url{https://phytoplankton.eoas.ubc.ca/}
#' @references {Kapustin, D., Sterlyagova, I. and Patova, E., 2019. Morphology of Chrysastrella paradoxa stomatocysts from the Subpolar Urals (Russia) with comments on related morphotypes. Phytotaxa, 402(6), pp.295-300.}

"species_mfg_library"
