% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recur-for-count.R
\name{recur_for_count}
\alias{recur_for_count}
\title{Control the number of times to recur}
\usage{
recur_for_count(x, n)
}
\arguments{
\item{x}{\verb{[rrule]}

A recurrence rule.}

\item{n}{\verb{[positive integer(1)]}

The number of times to recur for.}
}
\value{
An updated rrule.
}
\description{
\code{recur_for_count()} controls the total number of events in the recurrence
set. Using \code{recur_for_count()} will override the \code{until} date of the rule.
}
\details{
Remember that the number of times the occurrence has occurred is counted
from the \code{since} date! Adjust it as necessary to get your desired results.
}
\examples{
# Using the default `since` date
daily_since_epoch_for_5 <- daily() \%>\% recur_for_count(5)

alma_search("1969-12-31", "1970-01-25", daily_since_epoch_for_5)

# Changing the `since` date
daily_since_2019_for_5 <- daily(since = "2019-01-01") \%>\% recur_for_count(5)

alma_search("2018-12-31", "2019-01-25", daily_since_2019_for_5)

# In the case of "impossible" dates, such as 2019-02-31 and 2019-04-31 in the
# example below, they are not added to the total count. Only true event
# dates are counted.
on_31_for_5 <- monthly(since = "2019-01-01") \%>\%
  recur_on_mday(31) \%>\%
  recur_for_count(5)

alma_search("2019-01-01", "2020-01-01", on_31_for_5)
}
