% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amapro.R
\name{-- Introduction --}
\alias{-- Introduction --}
\title{Introduction}
\description{
Essential information, tips and tricks
}
\details{
We welcome AMap JavaScript library into the world of R. AMap is an
advanced mapping library made in China and widely used there. It
features 2D/3D animation, supports a multitude of layers and markers,
data import, flyover playback, etc. \if{html}{\out{<br />}} Library \emph{amapro} let you
control AMap from R and Shiny. It uses AMap’s native commands and
parameters wrapped in a few commands of its own.
}
\section{Translation}{
AMap’s documentation is in Chinese and most links here make reference to
it. If you happen \emph{not} to know Chinese, it is convenient to set your
browser to
\href{https://www.howtogeek.com/407924/how-to-turn-translation-on-or-off-in-chrome/}{auto-translate}.
This will help a little or a lot depending on the website/page
structure. One can also copy/paste text to \href{https://translate.google.com?sl=auto&tl=en}{Google translate}.
}

\section{Installation}{
\if{html}{\out{
<!-- Install **amapro** from CRAN with    <br>   
``` install.packages("amapro") ``` <br> -->
}}


Install \strong{amapro} from Github with \if{html}{\out{<br>}}
\code{remotes::install_github("helgasoft/amapro")} \if{html}{\out{<br>}} Then run the
following R commands \if{html}{\out{<br>}} \verb{library(amapro); am.init()} \if{html}{\out{<br>}} A pop-up
dialog will ask for an API key (shows once, will not be repeated). \if{html}{\out{<br>}}
API key is obtained through
\href{https://console.amap.com/dev/id/phone}{registration}, expecting you to
provide a Chinese phone number for the SMS verification code. \if{html}{\out{<br>}} How
to get an API key if you reside out of China?
\itemize{
\item ask a friend from China to help, or hire a local
\href{https://www.truelancer.com/freelancers-in-china}{freelancer}
\item search the web for a shared key
\item use a temporary Chinese phone number from sites like
\href{https://sms24.me/en/countries/cn/}{sms24},
\href{https://turtle-sms.xyz}{turtle-sms}, etc. However most are probably
blacklisted as the registration page shows them as \emph{already
registered}.
\item select temporarily the ‘demo’ option, without guarantee to work in
the long run
}
}

\section{Shiny Demo}{
Interactive, hands-on showcase of many library features. Activate with
the following command: \if{html}{\out{<br/>}} \verb{library(amapro); demo(am.shiny)}
}

\section{API links}{
\emph{amapro} is based on version 2.0 of AMap (JSAPI v2.0). “API”
auto-translates as “Reference book” in web menus.
\subsection{AMap}{

The base library with optional plugins. Most important links are
\itemize{
\item \href{https://lbs.amap.com/api/jsapi-v2/summary/}{Summary}
\item \href{https://lbs.amap.com/api/jsapi-v2/guide/abc/quickstart}{Guide}
\item \href{https://lbs.amap.com/api/jsapi-v2/documentation}{API}\if{html}{\out{<sup>}}1\if{html}{\out{</sup>}}
official documentation
\item \href{https://a.amap.com/jsapi/static/doc/20210906/index.html?v=2#map}{API}\if{html}{\out{<sup>}}2\if{html}{\out{</sup>}}
same as \if{html}{\out{<sup>}}1\if{html}{\out{</sup>}}, but better auto-translation
\item \href{https://lbs.amap.com/demo/list/jsapi-v2}{Examples} - live demos
\item \href{https://lbsbbs.amap.com/portal.php}{Forum} - reported issues
}
}

\subsection{LOCA}{

AMap extension with enhanced 3D features. In \emph{amapro} it is invoked with
a parameter \code{am.init(loca=TRUE, ...)}. The documentation auto-translates
well in Chrome.
\itemize{
\item \href{https://lbs.amap.com/api/loca-v2/intro}{Intro}
\item \href{https://a.amap.com/Loca/static/loca-v2/doc/html/index.html}{API}
documentation
}
}
}

\section{Commands}{
Controlling map and items is done by sending AMap commands to them. \if{html}{\out{<br>}}
Example: \code{am.cmd('setAngle', 'carIcon', -90)} \if{html}{\out{<br>}} \emph{amapro} uses native
AMap commands and introduces these \if{html}{\out{<ins>}}additional\if{html}{\out{</ins>}}:
\itemize{
\item \strong{set} - create new item
\itemize{
\item with \emph{name}: add new global JS object (\emph{window.\if{html}{\out{<name>}}}) outside
the map \if{html}{\out{<br>}} \code{am.cmd('set', 'VectorLayer', name='e$layer1')}
\item without \emph{name}: add new item to map \if{html}{\out{<br>}}
\code{am.cmd('set', 'e$marker1', position= c(116.478, 39.998))}
}
\item \strong{addTo} - append one existing JS object to another by name \if{html}{\out{<br>}}
\code{am.cmd('addTo', 'e$layer1', 'e$marker1')}
\item \strong{var} - set a JavaScript variable \if{html}{\out{<br>}}
\code{am.cmd('var', 'e$myOpacity', 0.8)}
\item \strong{code} - execute JavaScript code \if{html}{\out{<br>}}
\code{am.cmd('code', 'alert("I am JS");')}
}

AMap commands starting with \strong{get} return data from the map or related
objects. \if{html}{\out{<br>}} Put the data in a Shiny input variable by setting its name
in parameter \strong{r}. \if{html}{\out{<br>}} Example:
\code{am.cmd('getCenter', 'map', r='inShiny1')} \if{html}{\out{<br>}} Above command will
update \emph{input$inShiny1} with the Lng/Lat coordinates of the map center.
}

\section{Events}{
Events could be defined for map and items. All types of instances use
\strong{on/off methods} to bind and remove events. \if{html}{\out{<br>}} Events are set in
attribute \strong{on}(or \strong{off}) as a list of lists. Each event is a
separate list with event name in \strong{e}, a JS function \strong{f} and
optionally a query \strong{q}.
Example:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{am.init(center= c(116.475, 39.997), zoom= 17,
        on= list(list(e= 'complete', 
                      f= "function() \{alert('loaded!');\}")) )
}\if{html}{\out{</div>}}

on/off events without \emph{name} are ignored, except for the map itself (as
above example). \if{html}{\out{<br>}} Function \emph{Shiny.setInputValue()} can be used in
JavaScript to send data back to Shiny.
}

\section{Limitations}{
\itemize{
\item only one map is created by \emph{am.init} per session. It is a JS global
called ‘m$jmap’.
\item AMap command \emph{addTo} is overwritten by \emph{amapro} and cannot be used.
\item AMap plugins supported are ControlBar, Scale, ToolBar,
MoveAnimation, MouseTool, HeatMap, GeoJSON, ElasticMarker.
\item Loca supported items are GeoJSONSource, PolygonLayer, ScatterLayer,
LinkLayer, PulseLinkLayer. Loca events are not supported yet.
\item most \strong{built-in} AMap tile layers (Satellite, Traffic, Roads) are
limited to China only. However, with command \emph{am.item(‘TileLayer’)},
one can use any \href{https://leaflet-extras.github.io/leaflet-providers/preview/}{Leaflet provider}
for worldwide coverage.
\item AMap built-in \href{https://lbs.amap.com/api/jsapi-v2/guide/layers/official-layers}{map layers}
are \href{https://en.wikipedia.org/wiki/Restrictions_on_geographic_data_in_China}{GCJ-02 coded}
and coordinates collected on them will display incorrectly in
Leaflet or other WGS-84 based maps, and vice-versa. They need to be
\href{https://lbs.amap.com/api/jsapi-v2/guide/transform/convertfrom}{converted}.
Conversion is available through function
\href{https://lbs.amap.com/api/jsapi-v2/documentation#convertfrom}{convertFrom}.
\item AMap ecosystem is vast, some unsupported features include:
‘BesizerCurve’, ‘MarkerCluster’, ‘HawkEye’,
\href{https://lbs.amap.com/demo/javascript-api/example/indoormap/indoormap/}{IndoorMap},
\href{https://lbs.amap.com/demo/javascript-api/example/selflayer/cus-svg}{CustomLayer},
‘GLCustomLayer’, ‘DistrictLayer’, ‘LayerGroup’, all editors like
‘PolygonEditor’,‘Webservice’, ‘Search(AMap.Autocomplete,
AMap.PlaceSearch)’, ‘Geocoding(AMap.Geocoder)’, Route planning,
other services(weather, districts, etc.), positioning, utilities.
}
}

\section{Tips}{
\itemize{
\item all named objects created in JS are \href{https://developer.mozilla.org/en-US/docs/Glossary/Global_object}{global variables}
(\emph{window.name}). Good practice is to use a name prefix (m$) to avoid
overwriting accidentally external variables.
\item API attributes could be set to a JS function instead of a value.
Function is defined as a string starting with word “function”.
\item usually WMS/WMTS tiles come from external servers and may present a
CORS problem - browser refusal to load. One can install a small
\href{https://chrome.google.com/webstore/detail/allow-cors-access-control/lhobafahddgcelffkeicbaginigeejlf}{extension in Chrome}
or
\href{https://addons.mozilla.org/en-US/firefox/addon/access-control-allow-origin/}{Firefox}
to fix this problem manually inside the browser.
\item AMap has several predefined \href{https://lbs.amap.com/api/jsapi-v2/guide/map/map-style/}{Map styles}.
Could be set in map options with \emph{mapStyle}.
\item \emph{amapro} silent errors are collected in the browser Console. Press
key \strong{F12} to open the dev.environment, then open tab “Console” to
view them.
\item Chrome/Firefox extensions may interfere with map presentation (like
‘uBlock’)
}
}

