% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cookie.R
\name{cookie}
\alias{cookie}
\title{Cookie}
\usage{
cookie(
  name,
  value,
  expires = NULL,
  max_age = NULL,
  domain = NULL,
  path = NULL,
  secure = TRUE,
  http_only = TRUE,
  same_site = NULL
)
}
\arguments{
\item{name}{Name of the cookie.}

\item{value}{value of the cookie.}

\item{expires}{Expiry, if an integer assumes it's the number of seconds
from now. Otherwise accepts an object of class \code{POSIXct} or \code{Date}.
If a \code{character} string then it is set as-is and not pre-processed.
If unspecified, the cookie becomes a session cookie. A session finishes
when the client shuts down, after which the session cookie is removed.}

\item{max_age}{Indicates the number of seconds until the cookie expires.
A zero or negative number will expire the cookie immediately.
If both \code{expires} and \code{max_age} are set, the latter has precedence.}

\item{domain}{Defines the host to which the cookie will be sent.
If omitted, this attribute defaults to the host of the current document URL,
not including subdomains.}

\item{path}{Indicates the path that must exist in the requested URL for the
browser to send the Cookie header.}

\item{secure}{Indicates that the cookie is sent to the server only when a
request is made with the https: scheme (except on localhost), and therefore,
is more resistant to man-in-the-middle attacks.}

\item{http_only}{Forbids JavaScript from accessing the cookie, for example,
through the document.cookie property.}

\item{same_site}{Controls whether or not a cookie is sent with cross-origin
requests, providing some protection against cross-site request forgery
attacks (CSRF). Accepts \code{Strict}, \code{Lax}, or \code{None}.}
}
\description{
Create a cookie object.
}
\keyword{internal}
