% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cookie.R
\name{as_cookie_preprocessor}
\alias{as_cookie_preprocessor}
\title{Define a Cookie Preprocessor}
\usage{
as_cookie_preprocessor(fn)
}
\arguments{
\item{fn}{A function that accepts the same arguments
as the \code{cookie} method of the \link{Response} class
(name, value, ...), and returns a modified
\code{value}.}
}
\value{
Object of class "cookiePreprocessor".
}
\description{
Identifies a function as a cookie preprocessor.
}
\examples{
func <- function(name, value, ...) {
 sprintf("prefix.\%s", value)
}

prep <- as_cookie_preprocessor(func)

app <- Ambiorix$new()
app$use(prep)

}
