% File src/library/base/man/load.Rd
     \name{aml.estimate}
     \alias{aml.estimate}
     \title{Estimate Genetic Values Using AML Fit}
     \description{
       This function calculate the genetic values using the result from \code{amltest}.
       
     }
     \usage{
     aml.estimate(fit, marker, response, kin)
     }
     \arguments{
        \item{fit}{An object generated by \code{amltest} to be used to calculate genetic values.}
       \item{marker}{A matrix or data frame for the markers (or genetic effects).  It should be the same one used by \code{amltest} to generate \code{fit}.}
       \item{response}{A numerical vector of trait (phenotype) values.  It should be the same one used by \code{amltest} to generate \code{fit}.}
       \item{kin}{The kinship matrix representing relationships between lines.  It should be the same one used by \code{amltest} to generate \code{fit}. }
       
     }
     \details{
      This function is used to genetic values, i.e., fitted phenotypic values using genetic marker information.  It requires an adaptive mixed LASSO model has been fitted to the lines using \code{amltest} and the result is given in \code{fit}.  Thus this function will only calculate genetic values for lines with observed phenotypic values.  To make prediction for lines with only genetic information but no observed phenotypic values, use the function \code{aml.pred.outside }.
     }
     \value{
     A numeric vector containing estimated genetic values for lines analyzed by \code{amltest} to generate \code{fit}.
     }
     \seealso{
       \code{\link{amltest}}, \code{\link{aml.pred.outside}}.
     }

     \references{
 

      Wang, D., Eskridge, K.M. and Crossa, J. (2011)  Identifying QTLs and Epistasis in Structured Plant Populations Using Adaptive Mixed LASSO. \emph{Journal of Agricultural, Biological, and Environmental Statistics}, 16:170-184.

      Wang, D., \emph{et al.} (2012) Prediction of genetic values of quantitative traits with epistatic effects in plant breeding populations. \emph{Heredity}, 109: 313-319.
     }

     \examples{
     ## estimate genetic values for lines in the wheat data set
     data("wheat")
     clmarker<- cleanclust(wheat$marker, nafrac=0.2, mafb=0.1, corbnd=0.5, method="complete")
     intermat <- epigen(wheat$y, clmarker$newmarker, wheat$A, numkeep=100, selectvar=30, 
                          corbnd=0.5, mafb=0.04)
     resepi <- amltest(wheat$y, intermat$effects, wheat$A, numkeep=80, selectvar=40)
     predall<-aml.estimate(resepi, intermat$effects, wheat$y, wheat$A)
     
     }
     \keyword{adaptive mixed LASSO}

