% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/certificates.R
\name{as.certificate}
\alias{as.certificate}
\alias{certificates}
\alias{certificate}
\alias{certificate_create}
\title{Get list of certificate and their metadata, or a single certificate}
\usage{
as.certificate(x)

certificates(page = 1, per_page = 25, ...)

certificate(id, ...)

certificate_create(name, type, private_key = NULL,
  leaf_certificate = NULL, certificate_chain = NULL,
  dns_names = NULL, ...)
}
\arguments{
\item{x}{Object to coerce to an certificate}

\item{page}{Page to return. Default: 1.}

\item{per_page}{Number of results per page. Default: 25.}

\item{...}{Additional arguments passed down to low-level API function
(\code{do_*})}

\item{id}{(numeric) certificate id}

\item{name}{(character) a certificate name}

\item{type}{(character) a string representing the type of certificate.
The value should be "custom" for a user-uploaded certificate or
"lets_encrypt" for one automatically generated with Let's Encrypt.
If not provided, "custom" will be assumed by default.}

\item{private_key}{(character) the contents of a PEM-formatted private-key
corresponding to the SSL certificate}

\item{leaf_certificate}{(character) the contents of a PEM-formatted public
SSL certificate}

\item{certificate_chain}{(character) the full PEM-formatted trust chain
between the certificate authority's certificate and your domain's
SSL certificate}

\item{dns_names}{(character) a vector of fully qualified domain names
(FQDNs) for which the certificate will be issued. The domains must be
managed using DigitalOcean's DNS}
}
\description{
Get list of certificate and their metadata, or a single certificate
}
\examples{
\dontrun{
# list certificates
certificates()

# create a certificate (create a fake domain first)
d <- domain_create('tablesandchairsbunnies.stuff', '107.170.220.59')
certificate_create("mycert", "lets_encrypt", 
  dns_names = list('tablesandchairsbunnies.stuff'))
}
}
