% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.paths_animation}
\alias{plot.paths_animation}
\title{Plot animation path interpolation}
\usage{
\method{plot}{paths_animation}(x, ..., i = 1, level = 0.05, ylim_x = NULL, ylim_y = NULL)
}
\arguments{
\item{x}{\code{paths_animation} object as created through a call to \code{animate_paths()}.}

\item{...}{additional arguments passed to \code{plot}.}

\item{i}{index of individual to plot (corresponds to index in \code{unique(paths[, 'ID.name')}).}

\item{level}{confidence level for error bands. \code{NA} removes bands.}

\item{ylim_x}{y-axis limits for marginal plots (x, easting, etc.)}

\item{ylim_y}{y-axis limits for marginal plots (y, northing, etc.)}
}
\description{
This is mainly intended as a way to check that the interpolations used in the animation are working as expected.
}
\examples{
vultures$POSIX <- as.POSIXct(vultures$timestamp, tz = "UTC")
vultures_paths <- vultures[vultures$POSIX > as.POSIXct("2009-03-22", origin = "1970-01-01") & 
                             vultures$POSIX < as.POSIXct("2009-04-05", origin = "1970-01-01"), ]
interpolated_paths <- 
animate_paths(paths = vultures_paths,
              delta.t = 3600*6,
              coord = c("location.long", "location.lat"),
              Time.name = "POSIX",
              ID.name = "individual.local.identifier", 
              max.knots = 13,
              return.paths = TRUE)
interpolated_paths_gp <- 
animate_paths(paths = vultures_paths,
              delta.t = 3600*6,
              coord = c("location.long", "location.lat"),
              Time.name = "POSIX",
              ID.name = "individual.local.identifier", 
              max.knots = 3*13,
              return.paths = TRUE)
plot(interpolated_paths, i = 2)
plot(interpolated_paths_gp, i = 2, level = 0.01)
}
