% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/h5_processing.R
\name{addProcessingH5}
\alias{addProcessingH5}
\title{Add process results of antaresProcessing to an ANTARES .h5 files}
\usage{
addProcessingH5(
  opts = simOptions(),
  mcY = c("mcInd", "mcAll"),
  timeStep = "hourly",
  addNetLoad = FALSE,
  addDownwardMargin = FALSE,
  addUpwardMargin = FALSE,
  addExportAndImport = FALSE,
  addLoadFactorLink = FALSE,
  externalDependency = FALSE,
  loadFactor = FALSE,
  modulation = FALSE,
  netLoadRamp = FALSE,
  surplus = FALSE,
  surplusClusters = FALSE,
  thermalAvailabilities = FALSE,
  linkCapacity = FALSE,
  mustRun = FALSE,
  allProcess = FALSE,
  evalAreas = list(),
  evalLinks = list(),
  evalClusters = list(),
  evalDistricts = list(),
  nThreads = 1
)
}
\arguments{
\item{opts}{\code{simOptions} obtain which \link[antaresRead]{setSimulationPath}}

\item{mcY}{\code{character}, "mcInd" or "mcAll".}

\item{timeStep}{\code{character}, timeStep}

\item{addNetLoad}{\code{boolean} refer to \link[antaresProcessing]{addNetLoad}}

\item{addDownwardMargin}{\code{boolean} refer to \link[antaresProcessing]{addDownwardMargin}}

\item{addUpwardMargin}{\code{boolean} refer to \link[antaresProcessing]{addUpwardMargin}}

\item{addExportAndImport}{\code{boolean} refer to \link[antaresProcessing]{addExportAndImport}}

\item{addLoadFactorLink}{\code{boolean} refer to \link[antaresProcessing]{addLoadFactorLink}}

\item{externalDependency}{\code{boolean} refer to \link[antaresProcessing]{externalDependency}}

\item{loadFactor}{\code{boolean} refer to \link[antaresProcessing]{loadFactor}}

\item{modulation}{\code{boolean} refer to \link[antaresProcessing]{modulation}}

\item{netLoadRamp}{\code{boolean} refer to \link[antaresProcessing]{netLoadRamp}}

\item{surplus}{\code{boolean} refer to \link[antaresProcessing]{surplus}}

\item{surplusClusters}{\code{boolean} refer to \link[antaresProcessing]{surplusClusters}}

\item{thermalAvailabilities}{\code{boolean} Should the surplus of the last unit of a cluster be computed by \link[antaresProcessing]{surplusClusters}.
Should loadFactorAvailable be added to the result of \link[antaresProcessing]{loadFactor}.}

\item{linkCapacity}{\code{boolean} should export and import capacities be computed by \link[antaresProcessing]{addExportAndImport}.}

\item{mustRun}{\code{boolean} should the production in must run mode subtracted to the net load \link[antaresProcessing]{addNetLoad}.
Should the must run production be ignored in the computation of the netLoadRamp see \link[antaresProcessing]{netLoadRamp}.}

\item{allProcess}{\code{boolean} All process in one argument.}

\item{evalAreas}{\code{list}, list of operation to evaluate in areas data}

\item{evalLinks}{\code{list}, list of operation to evaluate in links data}

\item{evalClusters}{\code{list}, list of operation to evaluate in clusters data}

\item{evalDistricts}{\code{list}, list of operation to evaluate in districts data}

\item{nThreads}{\code{numeric}, nThreads to use}
}
\description{
In this version only hourly data can be enriched.
}
\details{
When you add a straitment, an alias is created. They can be used for request h5 file. See examples.

Available alias are :
\itemize{
   \item "Out_addDownwardMargin"
   \item "Out_addUpwardMargin"
   \item "Out_addExportAndImport"
   \item "Out_addLoadFactorLink"
   \item "Out_externalDependency"
   \item "Out_loadFactor"
   \item "Out_modulation"
   \item "Out_netLoadRamp"
   \item "Out_surplus"
   \item "Out_surplusClusters"
   }
}
\examples{

\dontrun{
addProcessingH5(opts = opts,  mcY = "mcInd",
               addDownwardMargin = TRUE,
               addUpwardMargin = TRUE,
               addExportAndImport = TRUE,
               addLoadFactorLink = TRUE,
               externalDependency = TRUE,
               loadFactor = TRUE,
               modulation = TRUE,
               netLoadRamp = TRUE,
               surplus = TRUE,
               surplusClusters = TRUE,
               evalAreas = list(Tota = "`H. STOR` + `MISC. DTG`",
                                Tota2 = "`NODU` + `NP COST` + 1"),
               evalLinks = list(),
               evalClusters = list(),
               evalDistricts = list()
               )

#After write of new columns, new aliases are avialable in antaresRead.You can use
#showAliases() to see them. Prifix Out_ is used to distinguish them.
showAliases("Out_surplusClusters")
readAntares(opts = opts, select = "Out_surplusClusters")

}

}
