% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_flights.R
\name{get_flights}
\alias{get_flights}
\title{Generate a flights dataset for a specified year and airport}
\source{
RITA, Bureau of transportation statistics,
 \url{http://www.transtats.bts.gov}
}
\usage{
get_flights(station, year, dir)
}
\arguments{
\item{station}{A character string---the airport of interest (use the FAA 
LID airport code).}

\item{year}{The year of interest, as an integer (unquoted). Currently, years 
2015 and on are supported. Information for the most recent year is usually 
available by February or March in the following year.}

\item{dir}{A character string--the folder for the dataset to be saved in}
}
\value{
A data frame with ~10k-500k rows and 19 variables:
\describe{
\item{year,month,day}{Date of departure}
\item{dep_time,arr_time}{Actual departure and arrival times, local tz.}
\item{sched_dep_time,sched_arr_time}{Scheduled departure and arrival times, local tz.}
\item{dep_delay,arr_delay}{Departure and arrival delays, in minutes.
  Negative times represent early departures/arrivals.}
\item{hour,minute}{Time of scheduled departure broken into hour and minutes.}
\item{carrier}{Two letter carrier abbreviation. See \code{\link{get_airlines}}
  to get name}
\item{tailnum}{Plane tail number}
\item{flight}{Flight number}
\item{origin,dest}{Origin and destination. See \code{\link{get_airports}} for
  additional metadata.}
\item{air_time}{Amount of time spent in the air, in minutes}
\item{distance}{Distance between airports, in miles}
\item{time_hour}{Scheduled date and hour of the flight as a \code{POSIXct} date.
  Along with \code{origin}, can be used to join flights data to weather data.}
}
}
\description{
Please note that, even with a strong internet connection, this function 
may take several minutes to download relevant data, and temporarily 
requires up to 2GB of storage (the file size is trimmed down significantly 
after some post-processing---to the order of a couple MB---and the larger 
files are deleted before termination)
}
\examples{
\donttest{get_flights(station = "MCI", year = 2016, dir = tempdir())}
}
\seealso{
\code{\link{get_airports}} for airport data, 
\code{\link{get_weather}} for weather data, \code{\link{get_airlines}} 
for airline data, and \code{\link{anyflights}} for a wrapper function
}
