% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apollo_ownModel.R
\name{apollo_ownModel}
\alias{apollo_ownModel}
\title{Calculates own model probabilities}
\usage{
apollo_ownModel(ownModel_settings, functionality)
}
\arguments{
\item{ownModel_settings}{List of arguments. Only likelihood is mandatory.
\itemize{
 \item \strong{\code{likelihood}}: Function or
       expression used to calculate the likelihood
       of the model. Should evaluate to a vector, 
       matrix, or 3-dimensional array.
 \item \strong{\code{prediction}}: Function or
       expression used to calculate the prediction
       of the model. Should evaluate to a vector, 
       matrix, or 3-dimensional array.
 \item \strong{\code{zero_LL}}: Function or
       expression used to calculate the likelihood
       of the base model (e.g. equiprobable model).
 \item \strong{\code{shares_LL}}: Function or
       expression used to calculate the likelihood
       of the constants-only model.
 \item \strong{\code{gradient}}: Function or
       expression used to calculate the gradient
       of the likelihood. If not provided, Apollo 
       will attempt to calculate it automatically.
 \item \strong{\code{report}}: List of functions or
       expressions used to produce a text report 
       summarising the input and parameter 
       estimates of the model. Should contain two 
       elements: "data" (with a summary of the 
       input data), and "param" (with a summary of 
       the estimated parameters).
}}

\item{functionality}{Character. Setting instructing Apollo what processing to apply to the likelihood function. This is in general controlled by the functions that call \code{apollo_probabilities}, though the user can also call \code{apollo_probabilities} manually with a given functionality for testing/debugging. Possible values are:
\itemize{
  \item \strong{\code{"components"}}: For further processing/debugging, produces likelihood for each model component (if multiple components are present), at the level of individual draws and observations.
  \item \strong{\code{"conditionals"}}: For conditionals, produces likelihood of the full model, at the level of individual inter-individual draws.
  \item \strong{\code{"estimate"}}: For model estimation, produces likelihood of the full model, at the level of individual decision-makers, after averaging across draws.
  \item \strong{\code{"gradient"}}: For model estimation, produces analytical gradients of the likelihood, where possible.
  \item \strong{\code{"output"}}: Prepares output for post-estimation reporting.
  \item \strong{\code{"prediction"}}: For model prediction, produces probabilities for individual alternatives and individual model components (if multiple components are present) at the level of an observation, after averaging across draws.
  \item \strong{\code{"preprocess"}}: Prepares likelihood functions for use in estimation.
  \item \strong{\code{"raw"}}: For debugging, produces probabilities of all alternatives and individual model components at the level of an observation, at the level of individual draws.
  \item \strong{\code{"report"}}: Prepares output summarising model and choiceset structure.
  \item \strong{\code{"shares_LL"}}: Produces overall model likelihood with constants only.
  \item \strong{\code{"validate"}}: Validates model specification, produces likelihood of the full model, at the level of individual decision-makers, after averaging across draws.
  \item \strong{\code{"zero_LL"}}: Produces overall model likelihood with all parameters at zero.
}}
}
\value{
The returned object depends on the value of argument \code{functionality} as follows.
        \itemize{
          \item \strong{\code{"components"}}: Same as \code{"estimate"}
          \item \strong{\code{"conditionals"}}: Same as \code{"estimate"}
          \item \strong{\code{"estimate"}}: vector/matrix/array. Returns the probabilities for the chosen alternative for each observation.
          \item \strong{\code{"gradient"}}: List containing the likelihood and gradient of the model component.
          \item \strong{\code{"output"}}: Same as \code{"estimate"} but also writes summary of input data to internal Apollo log.
          \item \strong{\code{"prediction"}}: List of vectors/matrices/arrays. Returns a list with the probabilities for all alternatives, with an extra element for the probability of the chosen alternative.
          \item \strong{\code{"preprocess"}}: Returns a list with pre-processed inputs, based on \code{mnl_settings}.
          \item \strong{\code{"validate"}}: Same as \code{"estimate"}, but it also runs a set of tests to validate the function inputs.
          \item \strong{\code{"raw"}}: Same as \code{"prediction"}
          \item \strong{\code{"report"}}: Choice overview
          \item \strong{\code{"shares_LL"}}: vector/matrix/array. Returns the probability of the chosen alternative when only constants are estimated.
          \item \strong{\code{"validate"}}: Same as \code{"estimate"}
          \item \strong{\code{"zero_LL"}}: vector/matrix/array. Returns the probability of the chosen alternative when all parameters are zero.
        }
}
\description{
Receives functions or expressions for each functionality so that a 
user-defined model can interface with Apollo.
}
