#' Generate base request
#'
#' This function takes a url and creates a basic httr2 request that
#' adds the user-agent and adds an authorization token to the
#' `X-Esri-Authorization` header.
#'
#' @param url a valid url that is passed to [`httr2::request()`]
#' @param token an object of class `httr2_token` as generated by [`auth_code()`]
#'  or related function
#' @param error_call the caller environment to be used when propagating errors.
#' @export
#' @examples
#' arc_base_req("https://arcgis.com")
arc_base_req <- function(url, token = NULL, error_call = rlang::caller_env()) {
  # set the user agent
  req <- arc_agent(httr2::request(url))

  # if token is not missing, check it
  if (!is.null(token)) {

    # ensure that the token is an httr2_token
    obj_check_token(token, error_call)

    # set the auth header
    req <- httr2::req_headers(
      req,
      "X-Esri-Authorization" = paste("Bearer", token[["access_token"]])
    )
  }

  req
}

