% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as-esri-geometry.R
\name{as_esri_geometry}
\alias{as_esri_geometry}
\alias{as_esri_features}
\alias{as_esri_featureset}
\alias{as_geometry}
\alias{as_features}
\alias{as_featureset}
\title{Create Esri geometry objects}
\usage{
as_esri_geometry(x, crs = 4326, ..., call = rlang::caller_env())

as_esri_features(x, ..., call = rlang::caller_env())

as_esri_featureset(x, ...)

as_geometry(x, crs, ...)

as_features(x, ..., call = rlang::caller_env())

as_featureset(x, ...)
}
\arguments{
\item{x}{an sf or sfc class object}

\item{crs}{the coordinate reference system of the FeatureSet. Must be interpretable by \code{sf::st_crs()}}

\item{...}{additional arguments passed on to methods.}

\item{call}{The execution environment of a currently running
function, e.g. \code{call = caller_env()}. The corresponding function
call is retrieved and mentioned in error messages as the source
of the error.

You only need to supply \code{call} when throwing a condition from a
helper function which wouldn't be relevant to mention in the
message.

Can also be \code{NULL} or a \link[rlang:topic-defuse]{defused function call} to
respectively not display any call or hard-code a code to display.

For more information about error calls, see \ifelse{html}{\link[rlang:topic-error-call]{Including function calls in error messages}}{\link[rlang:topic-error-call]{Including function calls in error messages}}.}
}
\value{
a json Esri geometry object
}
\description{
These functions convert R objects to Esri json representations. There are three
types of representations. These are, from smallest to largest, a \href{https://developers.arcgis.com/documentation/common-data-types/geometry-objects.htm}{geometry object}, a \href{https://developers.arcgis.com/documentation/common-data-types/feature-object.htm}{feature} and a \href{https://developers.arcgis.com/documentation/common-data-types/featureset-object.htm}{feature set}.
}
\details{
The \verb{_esri_} infix indicates that the input object will be converted directly into
the Esri JSON representation. If there is no \verb{_esri_} infix, the object will be
converted into the appropriate list structure requiring only
\code{jsonify::to_json(x, unbox = TRUE)} to convert to Esri JSON.
\itemize{
\item \code{as_esri_geometry()} converts an \code{sfg} object to a geometry object
\item \code{as_esri_features()} converts an \code{sfc} or \code{sf} object to a list of features
\item \code{as_esri_featureset()} converts an \code{sf}, \code{sfc}, or \code{data.frame} to a feature set object
}

Geometry object contain the coordinates for a geometry. Features are geometries that
have associated attributes with them. This would be similar to a row in an sf object.
FeatureSets are a list of features that have additional metadata fields such as
\code{spatialReference}, \code{geomtryType}, and \code{fields}. FeatureSets correspond to an
\code{sf} object.

Geometry objects are defined for 5 different types. These are:
\itemize{
\item Point: \code{esriGeometryPoint}
\item Multipoint: \code{esriGeometryMultipoint}
\item Polyline: \code{esriGeometryPolyline}
\itemize{
\item note that polyline encompasses both LINESTRING and MULTILINESTRING
}
\item Polygon: \code{esriGeometryPolygon}
\itemize{
\item note that polygon encompasses both POLYGON and MULTIPOLYGON
}
\item Envelope: \code{esriGeometryEnvelope}
\itemize{
\item envelopes correspond with bounding boxes but can have a Z dimension
}
}

Field handling:
\itemize{
\item Vectors that inherit \code{Date} or \code{POSIXt} are converted into milliseconds since
the Unix epoch in UTC timezone using \code{date_to_ms()}.
\item \code{factor}s are converted to character vectors using \code{as.character()} to match
the behavior in \code{infer_esri_type()} which defines type mapping for Esri
field types and R vector classes.
}
}
\examples{
library(sf)
as_esri_geometry(st_point(c(0, 1, 3, 4)))
as_esri_geometry(st_multipoint(x = matrix(runif(4), ncol = 2)))
as_esri_geometry(st_linestring(x = matrix(runif(2), ncol = 2)))
as_esri_geometry(st_linestring(x = matrix(runif(2), ncol = 2)))

# polygon
m <- matrix(
  c(0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 2, 2, 1, 2, 3, 1, 3, 2, 0, 0, 0),
  ncol = 3,
  byrow = TRUE
)
as_esri_geometry(st_polygon(list(m)))
}
