% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilityfcns.R
\name{summary.arfima}
\alias{summary.arfima}
\title{Extensive Summary of an Object}
\usage{
\method{summary}{arfima}(object, digits = max(4, getOption("digits") - 3),
  ...)
}
\arguments{
\item{object}{A fitted \code{arfima} object}

\item{digits}{The number of digits to print}

\item{\dots}{Optional arguments, currently not used.}
}
\value{
A list of lists (one for each mode) of all relevant information
about the fit that can be passed to \code{print.summary.arfima}.
}
\description{
Provides a very comprehensive summary of a fitted \code{arfima} object.
Includes correlation and covariance matrices (observed and expected), the
Fisher Information matrix of those parameters for which it is defined, and
more, for each mode.
}
\examples{

\donttest{
data(tmpyr)

fit <- arfima(tmpyr, order = c(1, 0, 1), back=T)
fit

summary(fit)
}

}
\references{
Veenstra, J.Q. Persistence and Antipersistence:  Theory and
Software (PhD Thesis)
}
\seealso{
\code{\link{arfima}}, \code{\link{iARFIMA}},
\code{\link{vcov.arfima}}
}
\author{
JQ (Justin) Veenstra
}
\keyword{ts}
