% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PutOptionsOverStrikePrices.R
\name{PutOptionsOverStrikePrices}
\alias{PutOptionsOverStrikePrices}
\title{Strike Price Sensitivity Analysis for European Put Option}
\usage{
PutOptionsOverStrikePrices(
  stock_data,
  future_time,
  sell_values,
  max.p = 5,
  max.q = 5,
  method = "CSS-ML"
)
}
\arguments{
\item{stock_data}{Numeric vector of stock prices data.}

\item{future_time}{Numeric constant of the future time}

\item{sell_values}{Numeric vector of the sell values to calculate the put option values at}

\item{max.p}{The maximum order of the autoregressive part of the ARMA model (default is 5)}

\item{max.q}{The maximum order of the moving average part of the ARMA model (default is 5)}

\item{method}{The way that the ARMA model is calculated, accepted values are "ML", "CSS-ML" and "CSS"}
}
\value{
Estimated values of a European put option at different sell values
}
\description{
This function calculates the value of the a European put option for a list of strike price / sell values, given stock price data and a given future time.
}
\examples{
library(stats)
library(forecast)

n = 100
set.seed(42)
arma_values = arima.sim(n = n, model = list(ar = c(0.6), ma = c(0.5, -0.5)))
linear_model = 5 + 1:n
stock_data = arma_values + linear_model


future_time = 2
sell_values = seq(90, 110, length.out = 5)

PutOptionsOverStrikePrices(stock_data, future_time, sell_values)


}
