% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/1_ModelsHeader.R, R/4_NetworkModels.R, R/5_SimulateModels.R
\name{Pi}
\alias{Pi}
\alias{Pi.ClosedJackson}
\alias{Pi.SimulatedNetwork}
\title{Steady-state probability of n customers at node i of a network.}
\usage{
Pi(net, n, node)

\method{Pi}{ClosedJackson}(net, n, node)

\method{Pi}{SimulatedNetwork}(net, n, node)
}
\arguments{
\item{net}{Closed Jackson Network}

\item{n}{Customers}

\item{node}{Node}
}
\value{
\ifelse{latex}{\eqn{P_{n}}}{\out{<i>P<sub>n</sub></i>}} in the selected node
}
\description{
Returns the value \ifelse{latex}{\eqn{P_{i}(n)}}{\out{<i>P<sub>i</sub>(n)</i>}} in the node i of a Closed Jackson Network
}
\details{
\code{Pi.ClosedJackson} implements the method for a Closed Jackson Network model

\code{Pi.SimulatedNetwork} implements the method for a SimulatedNetwork model
}
\examples{
#Probability of having 0 customers on node 2
Pi(ClosedJacksonNetwork(), 0, 2)

#It is possible obtain multiple probabilities
#for a node at once.
Pi(ClosedJacksonNetwork(), 0:2, 2)
}

