% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/3_ComplexModels.R
\name{M_M_1_INF_H}
\alias{M_M_1_INF_H}
\title{Obtains the main characteristics of a M/M/1/\eqn{\infty}/H queueing model}
\usage{
M_M_1_INF_H(lambda = 1/2, mu = 60/5, h = 5)
}
\arguments{
\item{lambda}{Mean arrival rate}

\item{mu}{Mean service rate}

\item{h}{Population size}
}
\value{
Returns the next information of a M/M/1/\eqn{\infty}/H model :
\item{rho}{Constant: \eqn{\lambda/\mu}}
\item{barrho}{Traffic intensity: \ifelse{latex}{\eqn{\bar{\rho}}}{{\out{<i>&#862;&rho;</i>}}}}
\item{barlambda}{Mean effective arrival rate: \ifelse{latex}{\eqn{\bar{\rho}}}{\out{<i>&#862;&lambda;</i>}}}
\item{cn}{Coefficients used in the computation of \ifelse{latex}{\eqn{P_n}: \eqn{C_n}}{\out{P<sub>n</sub>: <i>C<sub>n</sub></i>}}}
\item{p0}{Probability of empty system: \ifelse{latex}{\eqn{P_{0}}}{\out{<i>P<sub>0</sub></i>}}}
\item{l}{Number of customers in the system: \eqn{L}}
\item{lq}{Number of customers in the queue: \ifelse{latex}{\eqn{L_q}}{\out{<i>L<sub>q</sub></i>}}}
\item{w}{Waiting time in the system: \eqn{W}}
\item{wq}{Waiting time in the queue: \ifelse{latex}{\eqn{W_q}}{\out{<i>W<sub>q</sub></i>}}}
\item{eff}{System Efficiency: \ifelse{latex}{\eqn{Eff = W/(W-W_q)}}{\out{<i>Eff = W/(W-W<sub>q</sub>)</i>}}}
}
\description{
Obtains the main characteristics of a M/M/1/\eqn{\infty}/H queueing model
}
\examples{
# A computer system with five workstations must
# make a back- up from time to time, preventing
# users from using the system.
# The time between ending a back -up until the
# next begins is random and follows an
# exponential distribution with mean 2 hours.
# The duration of the backup is also random and
# follows an exponential distribution with mean
# 5 minutes.
# There exists a single tape drive to perform the
# back-up process and the station will wait if it is
# busy.

M_M_1_INF_H(lambda =1/2, mu=60/5, h=5)
}
\seealso{
Other AnaliticalModels: \code{\link{ClosedJacksonNetwork}};
  \code{\link{M_M_1_K}}; \code{\link{M_M_1}};
  \code{\link{M_M_INF}}; \code{\link{M_M_S_INF_H_Y}};
  \code{\link{M_M_S_INF_H}}; \code{\link{M_M_S_K}};
  \code{\link{M_M_S}}; \code{\link{OpenJacksonNetwork}}
}

