% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combinations.R
\docType{data}
\name{Combinations}
\alias{Combinations}
\alias{icombinations}
\title{Combinations iterator}
\format{An object of class \code{R6ClassGenerator} of length 24.}
\usage{
Combinations

icombinations(n, k, x = NULL, freq = NULL, replace = FALSE)
}
\arguments{
\item{n}{an integer. If \code{freq} is not NULL, \code{n} would be set as \code{sum(freq)},
otherwise if \code{x} is not NULL, \code{n} would be set as \code{length(x)}.}

\item{k}{an integer}

\item{x}{an optional vector indicating item labels}

\item{freq}{an integer vector of item repeat frequencies}

\item{replace}{an logical to draw items with replacement}
}
\description{
This function returns a \href{Combinations-class.html}{Combinations} iterator for iterating
combinations of \code{k} items from \code{n} items. The iterator allows users to fetch the next
combination(s) via the \code{getnext()} method.
}
\details{
The \code{Combinations} class can be initialized by using the convenient wrapper \code{icombinations} or
\preformatted{
Combinations$new(n, k, x = NULL, freq = NULL, replace = FALSE)
}

\preformatted{
getnext(d = 1L, type = NULL, drop = d == 1L && is.null(type))
collect(type = "r")
reset()
}
\describe{
\item{d}{number of fetched arrangements}

\item{type}{if "r", "c" or "l" is specified, the returned value would be a
 "row-major" matrix, a "column-major" matrix or a list respectively}

\item{drop}{vectorize a matrix or unlist a list}
}
}
\examples{
icomb <- icombinations(5, 2)
icomb$getnext()
icomb$getnext(2)
icomb$getnext(type = "c", drop = FALSE)
# collect remaining combinations
icomb$collect()

library(foreach)
foreach(x = icombinations(5, 2), .combine=c) \%do\% {
  sum(x)
}
}
\seealso{
\link{combinations} for generating all combinations and \link{ncombinations} to calculate number of combinations
}
\keyword{datasets}
