% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert_type.R
\name{assert_non_empty_string}
\alias{assert_non_empty_string}
\title{Assert input is a  non empty character string}
\usage{
assert_non_empty_string(
  x,
  msg = NULL,
  call = rlang::caller_env(),
  arg_name = NULL
)
}
\arguments{
\item{x}{An object}

\item{msg}{A character string containing the error message to display if x is not a}

\item{call}{Only relevant when pooling assertions into multi-assertion helper functions. See \link[cli]{cli_abort} for details.}

\item{arg_name}{Advanced use only. Name of the argument passed (default: NULL, will automatically extract arg_name).}
}
\value{
invisible(TRUE) if x is a character vector, otherwise aborts with the error message specified by msg
}
\description{
Asserts input is a string, and nonempty (i.e. not equal to '')
}
\examples{
try({
assert_non_empty_string("a") # Passes
assert_non_empty_string("") # Fails
})


}
\concept{assert_type}
