% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replace_consecutive.R
\name{replace_consecutive}
\alias{replace_consecutive}
\title{Replaces consecutive elements}
\usage{
replace_consecutive(x, by = "")
}
\arguments{
\item{x}{A character or factor.}

\item{by}{A character with length 1.}
}
\value{
A character, same length as \code{x}, now with consecutives replaced by \code{by}.
If \code{length(x) < 2}, x is returned unchanged.
}
\description{
If \code{x[i+1]=x[i]} then \code{x[i+1]} is replaced by \code{by} for \code{i=1,...length(x)-1}.
}
\details{
The \code{=} is defined by function \code{\link[base]{identical}}.
}
\examples{
x <- rep(c('a','b','c','d'), times=c(2,4,1,3))
x
\dontrun{replace_consecutive(x)}

}
