% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-conv-mgnbiot.R
\name{get_conv_mgnbiot}
\alias{get_conv_mgnbiot}
\title{Extract conversion factor used to transform data from nitrogen in mg to
biomass in tonnes.}
\usage{
get_conv_mgnbiot(prm_biol)
}
\arguments{
\item{prm_biol}{Character string giving the connection to the biological parameterfile.
The filename usually contains \code{biol_fishing} and does end in \code{.prm}.}
}
\value{
Conversion factor as numeric value.
}
\description{
Extract conversion factor used to transform data from nitrogen in mg to
biomass in tonnes.
}
\examples{
d <- system.file("extdata", "setas-model-new-trunk", package = "atlantistools")
prm_biol <- file.path(d, "VMPA_setas_biol_fishing_Trunk.prm")

get_conv_mgnbiot(prm_biol)
}
\seealso{
Other get functions: \code{\link{get_boundary}},
  \code{\link{get_colpal}}, \code{\link{get_groups}}
}
