% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-maturity-fishbase.R
\name{get_maturity_fishbase}
\alias{get_maturity_fishbase}
\title{Extract maturity parameters from http:://www.fishbase.se.}
\usage{
get_maturity_fishbase(fish, mirror = "se")
}
\arguments{
\item{fish}{Vector of fish species with genus and species information.}

\item{mirror}{Character string defining the url mirror to use. Defaults to \code{se}.
In case data extraction is slow use a different mirror. Try to avoid frequently used mirrors
like \code{uk} or \code{com}.}
}
\value{
Dataframe with species, country, locality, linf and k.
}
\description{
This function extracts values for maturity from http:://www.fishbase.se
}
\details{
Before the actual extraction takes place fishbase IDs for every species are extracted using \code{\link{get_ids_fishbase}}.
The IDs are needed to generate the urls later on.
}
\examples{
\dontrun{
# For some reason the examples break with appveyor.
fish <- c("Gadus morhua", "Squalus acanthias")
df <- get_maturity_fishbase(fish)
head(df)
}
}
