% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/att_from_namespace.R
\name{att_from_namespace}
\alias{att_from_namespace}
\title{return package dependencies from NAMESPACE file}
\usage{
att_from_namespace(path = "NAMESPACE", document = TRUE, clean = TRUE)
}
\arguments{
\item{path}{path to NAMESPACE file}

\item{document}{Run function roxygenise of roxygen2 package}

\item{clean}{Logical. Whether to remove the original NAMESPACE before updating}
}
\value{
a vector
}
\description{
return package dependencies from NAMESPACE file
}
\examples{
tmpdir <- tempfile(pattern = "namespace")
dir.create(tmpdir)
file.copy(system.file("dummypackage",package = "attachment"), tmpdir,
 recursive = TRUE)
dummypackage <- file.path(tmpdir, "dummypackage")
# browseURL(dummypackage)
att_from_namespace(path = file.path(dummypackage, "NAMESPACE"))

# Clean temp files after this example
unlink(tmpdir, recursive = TRUE)
}
