% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auk-country.R
\name{auk_country}
\alias{auk_country}
\title{Filter the eBird data by country}
\usage{
auk_country(x, country, replace = FALSE)
}
\arguments{
\item{x}{\code{auk_ebd} or \code{auk_sampling} object; reference to file created by
\code{\link[=auk_ebd]{auk_ebd()}} or \code{\link[=auk_sampling]{auk_sampling()}}.}

\item{country}{character; countries to filter by. Countries can either be
expressed as English names or
\href{https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2}{ISO 2-letter country codes}.
English names are matched via regular expressions using
\link[countrycode:countrycode]{countrycode}, so there is some flexibility in names.}

\item{replace}{logical; multiple calls to \code{auk_country()} are additive,
unless \code{replace = FALSE}, in which case the previous list of countries to
filter by will be removed and replaced by that in the current call.}
}
\value{
An \code{auk_ebd} object.
}
\description{
Define a filter for the eBird Basic Dataset (EBD) based on a set of
countries. This function only defines the filter and, once all filters have
been defined, \code{\link[=auk_filter]{auk_filter()}} should be used to call AWK and perform the
filtering.
}
\details{
This function can also work with on an \code{auk_sampling} object if the
user only wishes to filter the sampling event data.
}
\examples{
# country names and ISO2 codes can be mixed
# not case sensitive
country <- c("CA", "United States", "mexico")
system.file("extdata/ebd-sample.txt", package = "auk") |>
  auk_ebd() |>
  auk_country(country)
  
# alternatively, without pipes
ebd <- auk_ebd(system.file("extdata/ebd-sample.txt", package = "auk"))
auk_country(ebd, country)
}
\seealso{
Other filter: 
\code{\link{auk_bbox}()},
\code{\link{auk_bcr}()},
\code{\link{auk_breeding}()},
\code{\link{auk_complete}()},
\code{\link{auk_county}()},
\code{\link{auk_date}()},
\code{\link{auk_distance}()},
\code{\link{auk_duration}()},
\code{\link{auk_exotic}()},
\code{\link{auk_extent}()},
\code{\link{auk_filter}()},
\code{\link{auk_last_edited}()},
\code{\link{auk_observer}()},
\code{\link{auk_project}()},
\code{\link{auk_protocol}()},
\code{\link{auk_species}()},
\code{\link{auk_state}()},
\code{\link{auk_time}()},
\code{\link{auk_year}()}
}
\concept{filter}
