% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_routines.R
\name{generate_all_subtrees}
\alias{generate_all_subtrees}
\title{Generate all subtrees from a tree.}
\usage{
generate_all_subtrees(th)
}
\arguments{
\item{th}{An object of class TreeHarp.}
}
\value{
A 0-1 matrix with n rows and m columns. n is the number of sub-trees
rooted at the root node of th. m is the number of nodes in this given tree.
The leading column will be a 1 for all the rows.
}
\description{
This routines generates all subtrees rooted at the root node for a particular
tree.
}
\examples{
th1 <- TreeHarp(list(a=c(2,3), b=NULL, c=NULL))
generate_all_subtrees(th1)
}
\references{
\emph{Listing and counting subtrees of a tree}, F Ruskey, \emph{SIAM Journal on Computing}, 1981
}
\seealso{
\code{\link{get_next_subtree}}
}
