% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_kernel.R
\name{jaccard_treeharp}
\alias{jaccard_treeharp}
\title{Computes Jaccard Index}
\usage{
jaccard_treeharp(th1, th2, weighted = FALSE)
}
\arguments{
\item{th1}{A TreeHarp object.}

\item{th2}{A TreeHarp object.}

\item{weighted}{A logical value, indicating if the weighted Jaccard 
similarity should be computed.}
}
\value{
A real number between 0 and 1.
}
\description{
Computes the Jaccard index between two trees.
}
\details{
The unweighted form is just the cardinality of the intersection 
of the two sets of tokens, divided by the union of the two sets.

The weighted form is described on the WIkipedia page:
https://en.wikipedia.org/wiki/Jaccard_index#Weighted_Jaccard_similarity_and_distance
}
