% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_avesperu.R
\name{search_avesperu}
\alias{search_avesperu}
\title{Retrieve Data from the List of the Birds of Peru}
\usage{
search_avesperu(splist, max_distance = 0.1)
}
\arguments{
\item{splist}{A character vector containing the names of the species to search for.}

\item{max_distance}{The maximum allowed distance for fuzzy matching of species names.
Defaults to 0.1.}
}
\value{
A data frame containing the retrieved information for each species.
}
\description{
This function takes a list of birds species names, searches for their data in
the avesperu pacakage dataset, and returns a data frame containing the relevant
information for each species.
}
\details{
The function allows fuzzy matching for species names with a maximum
distance threshold to handle potential typos or variations in species names.
}
\examples{

splist <- c("Falco sparverius", "Tinamus osgodi", "Crypturellus sooui",
            "Thraupisa palamarum", "Thamnophilus praecox")

search_avesperu(splist)

}
