% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_tandem_id_from_phenotype_id.R
\name{get_tandem_id_from_phenotype_id}
\alias{get_tandem_id_from_phenotype_id}
\title{Get tandem repeat from phenotype}
\usage{
get_tandem_id_from_phenotype_id(
  phenotype_id,
  seed_id = sample(1:1000, 1),
  tandem_seq = FALSE,
  tandem_pos = FALSE,
  triplestore
)
}
\arguments{
\item{phenotype_id}{Integer or list of integer values.}

\item{seed_id}{Integer (from 1 to 1000) or a vector of integer values. This
integer is used for starting the pseudo-random number generator that
represents the environment experiencing a digital organism. If seed_id value
is not specified, it returns data for a single randomly chosen seed_id value
(between 1 and 1000).}

\item{tandem_seq}{Logical value (TRUE/FALSE) to show/hide this column
(FALSE by default).}

\item{tandem_pos}{Logical value (TRUE/FALSE) to show/hide this column
(FALSE by default).}

\item{triplestore}{Object of class triplestore_access which manages database
access.}
}
\value{
Data frame. Column: "seed_id" (optional), "phenotype_id",
"tandem_id", "tandem_seq" (optional), "tandem_pos (optional)."
}
\description{
Get the tandem repeat contained in the transcriptome of a
digital organism that encodes a specific phenotype for a list of seeds used
for starting the pseudo-random number generator (i.e., a set of environments).
}
\examples{

# Create triplestore object
avidaDB <- triplestore_access$new()

# Set access options
avidaDB$set_access_options(
  url = "https://graphdb.fortunalab.org",
  user = "public_avida",
  password = "public_avida",
  repository = "avidaDB_test"
)

# Single phenotype
get_tandem_id_from_phenotype_id(
  phenotype_id = 8, tandem_seq = TRUE,
  triplestore = avidaDB
)

# More than one phenotype at seed_1
get_tandem_id_from_phenotype_id(
  phenotype_id = c(2, 4, 8), seed_id = 1,
  triplestore = avidaDB
)

# At seed_1 and seed_2
get_tandem_id_from_phenotype_id(
  phenotype_id = 1,
  seed_id = c(1, 2),
  tandem_pos = TRUE,
  triplestore = avidaDB
)

}
