% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_transcription.R
\name{get_transcription}
\alias{get_transcription}
\title{Get AWS Transcribe Job}
\usage{
get_transcription(job, download = TRUE, ...)
}
\arguments{
\item{job}{A character string specifying the name of a job, possibly returned by \code{\link{list_transcriptions}}.}

\item{download}{A logical indicating whether to download the transcription(s).}

\item{\dots}{Additional arguments passed to \code{\link{transcribeHTTP}}.}
}
\value{
A list.
}
\description{
Retrieve a specific AWS Transcribe job
}
\examples{
\dontrun{
# start a transcription
## upload a file to S3
library("aws.s3")
put_object(file = "recording.mp3", bucket = "my-bucket", object = "recording.mp3")

## start trancription
start_transcription("first-example", "https://my-bucket.us-east-1.amazonaws.com/recording.mp3")

## wait
Sys.sleep(5)

## retrieve transcription
transcript <- get_transcription("first-example")
transcript$Transcriptions
}
}
\seealso{
\code{\link{start_transcription}}, \code{\link{list_transcriptions}}
}
