% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atmospheric_attenuation.R
\name{atmospheric_attenuation}
\alias{atmospheric_attenuation}
\title{Measure atmospheric attenuation and absorption of sound}
\usage{
atmospheric_attenuation(f, temp, RH, p = 101325, 
formula = 1, spi = NULL, dist = NULL)
}
\arguments{
\item{f}{numeric vector of length 1 with frequency (in Hertz).}

\item{temp}{numeric vector of length 1 with frequency (in Celsius).}

\item{RH}{numeric vector of length 1 with relative humidity}

\item{p}{numeric vector of length 1 with ambient pressure in Pa (standard: 101325, default).}

\item{formula}{1 = Bazley 1976, 2 = Rossing 2007 (p. 116, see details).}

\item{spi}{numeric vector of length 1 with the initial sound pressure in Pa. Required for calculating atmospheric absorption. Default is \code{NULL}.}

\item{dist}{numeric vector of length 1 with distance (m) over which a sound propagates. Required for calculating atmospheric absorption. Default is \code{NULL}.}
}
\value{
Returns atmospheric attenuation (in dB/m) of sound based on supplied parameters. If 'spi' and 'dist' are supplied the function also returns atmospheric absorption (in dB).
}
\description{
\code{atmospheric_attenuation} measures atmospheric attenuation and atmospheric absorption.
}
\details{
Calculate the atmospheric attenuation based on temperature, relative humidity, pressure and sound frequency. The function can applied to formulae based on:
\itemize{
\item \code{1}: default. As used by Bazley (1976), Sound absorption in air at frequencies up to 100 kHz. NPL acoustics report Ac 74. 
\item \code{2}: as used by Rossing (2007), Handbook of Acoustics, Springer.
}
If 'spi' and 'dist' are supplied the function also returns the atmospheric absorption (in dB).
}
\examples{
{
# load example data
data("playback_est")

#' # remove ambient selections
playback_est <- playback_est[playback_est$signal.type != "ambient", ]

# measure atmospheric attenuation formula 1
atmospheric_attenuation(f = 20000, temp = 20, RH = 90, p = 88000, formula = 1)
}

}
\references{
{
Araya-Salas, M. (2020). baRulho: baRulho: quantifying habitat-induced degradation of (animal) acoustic signals in R. R package version 1.0.2
}
}
\author{
Marcelo Araya-Salas (\email{marceloa27@gmail.com})
}
