% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/b2CreateBucket.R
\name{b2CreateBucket}
\alias{b2CreateBucket}
\title{Create B2 Bucket.}
\usage{
b2CreateBucket(bucketName, bucketType)
}
\arguments{
\item{bucketName}{Bucket names must be globally unique. No two users may have
buckets named the same. Bucket names may not start with \emph{b2}. Bucket
names must be a minimum of 6 and maximum of 50 characters long. Bucket
names may consist only of letters, numbers and hyphens. Special characters
are invalid.}

\item{bucketType}{Supported bucket types are \emph{allPublic} and
\emph{allPrivate}.}
}
\value{
If successful a list containing the \code{accountId},
  \code{bucketName} and \code{bucketType} will all be echoed back to the
  user. Also included in the return list will be a unique \code{bucketId}.
}
\description{
\code{b2CreateBucket} creates a new bucket in the user's account on the
Backblaze B2 cloud storage product.
}
\details{
This function creates a new bucket within the user's account on the Backblaze
B2 cloud storage product. Backblaze B2 does not support tree based folder
structures as such, meaning all uploaded data is stored in a flat file
structure. However, buckets may be created at the top level to aid in content
organisation. Further details regarding this API call are available here:

\url{https://www.backblaze.com/b2/docs/b2_create_bucket.html}

\code{bucketName} and \code{bucketType} are mandatory and must be user
defined.
}
\examples{
\dontrun{
b2CreateBucket(bucketName = "this-is-a-uniquely-named-bucket",
bucketType = "allPublic")
}

}

