% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/b2DeleteBucket.R
\name{b2DeleteBucket}
\alias{b2DeleteBucket}
\title{Delete B2 Bucket.}
\usage{
b2DeleteBucket(bucketId)
}
\arguments{
\item{bucketId}{The unique identifier of the bucket to be deleted. A
list of all the user's bucket IDs may be found using the
\code{b2_list_buckets} function in this package.}
}
\value{
If successful a list containing the \code{accountId},
  \code{bucketId}, \code{bucketName} and \code{bucketType} of the deleted
  bucket will all be echoed back to the user.
}
\description{
\code{b2DeleteBucket} deletes an existing bucket in the user's account on the
Backblaze B2 cloud storage product.
}
\details{
This function deletes an existing bucket within the user's account on the
Backblaze B2 cloud storage product. Further details regarding this API call
are available here:

\url{https://www.backblaze.com/b2/docs/b2_delete_bucket.html}

\code{bucketId} is mandatory and must be user defined.
}
\examples{
\dontrun{
b2DeleteBucket(bucketId = "aUniqueBucketId")
}

}

