% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bicm.R
\name{bicm}
\alias{bicm}
\title{bicm: Bipartite Configuration Model.}
\usage{
bicm(graph, tol = 1e-08, max_steps = 200, ...)
}
\arguments{
\item{graph}{matrix, a bipartite adjacency matrix of a graph}

\item{tol}{numeric, tolerance of algorithm}

\item{max_steps}{numeric, number of times to run \link{loglikelihood_prime_bicm} algorithm}

\item{...}{optional arguments}
}
\value{
matrix containing probabilities
}
\description{
bicm: Bipartite Configuration Model.
}
\details{
The Bipartite Configuration Model (Saracco et. al. 2015, 2017) produces a matrix of edge specific probabilities which are used in \link{sdsm} to find the p-values of the edges in the bipartite projection. This R code is adapted from the python BiCM package by Matteo Bruno under the MIT license.
}
\examples{
bicm(davis)
}
\references{
python bicm: \href{https://github.com/mat701/BiCM}{Matteo Bruno, matteo.bruno<at>imtlucca.it, https://github.com/mat701/BiCM}

bicm: {Saracco, F., Straka, M. J., Clemente, R. D., Gabrielli, A., Caldarelli, G., & Squartini, T. (2017). Inferring monopartite projections of bipartite networks: An entropy-based approach. New Journal of Physics, 19(5), 053022. \doi{10.1088/1367-2630/aa6b38}}

bicm: {Saracco, F., Di Clemente, R., Gabrielli, A., & Squartini, T. (2015). Randomizing bipartite networks: The case of the World Trade Web. Scientific Reports, 5(1), 10595. \doi{10.1038/srep10595}}
}
