% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bage_mod-functions.R
\name{set_datamod_miscount}
\alias{set_datamod_miscount}
\title{Specify Miscount Data Model}
\usage{
set_datamod_miscount(mod, prob, rate)
}
\arguments{
\item{mod}{An object of class \code{"bage_mod_pois"},
created with \code{\link[=mod_pois]{mod_pois()}}.}

\item{prob}{The prior for the probability
that a person or event in the target
population will correctly enumerated.
A data frame with a variable
called \code{"mean"}, a variable called \code{"disp"},
and, optionally, one or more 'by' variables.}

\item{rate}{The prior for the overcoverage rate.
A data frame with a variable
called \code{"mean"}, a variable called \code{"disp"},
and, optionally, one or more 'by' variables.}
}
\value{
A revised version of \code{mod}.
}
\description{
Specify a data model for the outcome
in a Poisson model, where the outcome
is subject to undercount and
overcount.
}
\details{
The miscount data model is essentially a combination
of the \link[=set_datamod_undercount]{undercount}
and \link[=set_datamod_overcount]{overcount}
data models. It assumes that
reported outcome is the sum of two quantities:
\enumerate{
\item \emph{Units from target population, undercounted}
People or events belonging
to the target population, in which
each unit's inclusion probability
is less than 1.
\item \emph{Overcount} People or events
that do not belong to target population,
or that are counted more than once.
}

If, for instance, a census
enumerates 91 people from a true population
of 100, but also mistakenly enumerates
a further 6 people, then
\itemize{
\item the true value for the outcome variable is 100
\item the value for the undercounted target population is 91,
\item the value for the overcount is 6, and
\item the observed value for the outcome variable is 91 + 6 = 97.
}
}
\section{The \code{prob} argument}{


The \code{prob} argument specifies a prior
distribution for the probability
that a person or event in the target
population is included in the
reported outcome. \code{prob} is a
data frame with a variable called \code{"mean"},
a variable called \code{"disp"}, and, optionally,
one or more 'by' variables.
For instance, a  \code{prob} of

\if{html}{\out{<div class="sourceCode">}}\preformatted{data.frame(sex = c("Female", "Male"),
           mean = c(0.95, 0.92),
           disp = c(0.02, 0.015))
}\if{html}{\out{</div>}}

implies that the expected value for
the inclusion probability is 0.95 for females
and 0.92 for males, with slightly more
uncertainty for females than for males.
}

\section{The \code{rate} argument}{


The \code{rate} argument specifies a prior
distribution for the overcoverage
rate. \code{rate} is a
data frame with a variable called \code{"mean"},
a variable called \code{"disp"}, and, optionally,
one or more 'by' variables.
For instance, a  \code{rate} of

\if{html}{\out{<div class="sourceCode">}}\preformatted{data.frame(mean = 0.03, disp = 0.1)
}\if{html}{\out{</div>}}

implies that the expected value for
the overcoverage rate is 0.03,
with a dispersion of 0.1. Since no 'by'
variables are included, the same
mean and dispersion values are
applied to all cells.
}

\section{Mathematical details}{


The model for the observed outcome is

\deqn{y_i^{\text{obs}} = u_i + v_i}
\deqn{u_i \sim \text{Binomial}(y_i^{\text{true}}, \pi_{g[i]})}
\deqn{v_i \sim \text{Poisson}(\kappa_{h[i]} \gamma_i w_i)}
\deqn{\pi_g \sim \text{Beta}(m_g^{(\pi)} / d_g^{(\pi)}, (1-m_g^{(\pi)}) / d_g^{(\pi)})}
\deqn{\kappa_h \sim \text{Gamma}(1/d_h^{(\kappa)}, 1/(d_h^{(\kappa)} m_h^{(\kappa)}))}

where
\itemize{
\item \eqn{y_i^{\text{obs}}} is the observed outcome for cell \eqn{i};
\item \eqn{y_i^{\text{true}}} is the true outcome for cell \eqn{i};
\item \eqn{\gamma_i} is the rate for cell \eqn{i};
\item \eqn{w_i} is exposure for cell \eqn{i};
\item \eqn{\pi_{g[i]}} is the probability that a member of the
target population in cell \eqn{i} is correctly enumerated in that cell;
\item \eqn{\kappa_{h[i]}} is the overcoverage rate for cell \eqn{i};
\item \eqn{m_g^{(\pi)}} is the expected value for \eqn{\pi_g}
(specified via \code{prob});
\item \eqn{d_g^{(\pi)}} is disperson for \eqn{\pi_g} (specified via \code{prob});
\item \eqn{m_h^{(\kappa)}} is the expected value for \eqn{\kappa_h}
(specified via \code{rate}); and
\item \eqn{d_h^{(\kappa)}} is disperson for \eqn{\kappa_h} (specified via \code{rate}).
}
}

\examples{
## specify 'prob' and 'rate'
prob <- data.frame(sex = c("Female", "Male"),
                   mean = c(0.95, 0.97),
                   disp = c(0.05, 0.05))
rate <- data.frame(mean = 0.03, disp = 0.15)

## specify model
mod <- mod_pois(divorces ~ age * sex + time,
                data = nzl_divorces,
                exposure = population) |>
  set_datamod_miscount(prob = prob, rate = rate)
mod

## fit model
mod <- mod |>
  fit()
mod

## original data, plus imputed values for outcome
mod |>
  augment()

## parameter estimates
library(dplyr)
mod |>
  components() |>
  filter(term == "datamod")

## the data have in fact been confidentialized,
## so we account for that, in addition
## to accounting for undercoverage and
## overcoverage
mod <- mod |>
 set_confidential_rr3() |>
 fit()
mod
}
\seealso{
\itemize{
\item \code{\link[=mod_pois]{mod_pois()}} Specify a Poisson model
\item \code{\link[=augment]{augment()}} Original data plus estimated values,
including estimates of true value for
the outcome variable
\item \code{\link[=components]{components()}} Estimated values for
model parameters, including inclusion
probabilities and overcount rates
\item \code{\link[=set_datamod_undercount]{set_datamod_undercount()}} An undercount-only
data model
\item \code{\link[=set_datamod_overcount]{set_datamod_overcount()}} An overcount-only
data model
\item \link{datamods} All data models implemented in \code{bage}
\item \link{confidential} Confidentialization
procedures modeled in \code{bage}
\item \href{https://bayesiandemography.github.io/bage/articles/vig02_math.html}{Mathematical Details}
vignette
}
}
