% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/balance.plot.R
\docType{class}
\name{bplot-class}
\alias{bplot-class}
\alias{show,bplot-method}
\alias{[[,bplot-method}
\title{A pba model S4 class}
\usage{
\S4method{show}{bplot}(object)

\S4method{[[}{bplot}(x, i)
}
\arguments{
\item{object, x}{A \code{bplot} object.}

\item{i}{An integer. Used to index the \code{bplot} object.}
}
\description{
A pba model S4 class
}
\section{Methods (by generic)}{
\itemize{
\item \code{show}: Method to show \code{bplot} object.

\item \code{[[}: Method to subset \code{bplot} object.
}}

\section{Slots}{

\describe{
\item{\code{balance.partition}}{A \code{ggplot} object. The "partition" sub-plot.}

\item{\code{balance.distribution}}{A \code{ggplot} object. The "distribution" sub-plot.}

\item{\code{balances}}{The results of \code{balance.fromSBP}.}
}}

\examples{
library(balance)
data(iris)
x <- iris[,1:4]
sbp <- sbp.fromPBA(x)
balance(x, sbp)

}
\author{
Thom Quinn
}
