% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bar3d.R
\name{bar3d}
\alias{bar3d}
\title{Adds a single 3D bar to the current scene}
\usage{
bar3d(x = c(0, 1), y = c(0, 1), z, alpha = 1, topcol = "#078E53",
  sidecol = "#aaaaaa", linecol = "#000000")
}
\arguments{
\item{x}{The x dimensions of the bar, a vector of length 2 e.g. c(0,1).}

\item{y}{The y dimensions of the bar, a vector of length 2 e.g. c(0,1).}

\item{z}{The height of the bar, a single number, e.g 3.}

\item{alpha}{The alpha channel (transparency) of the sides of the bar. Range 0-1.}

\item{topcol}{The color of the top of the bar. Text description or hexadecimal RGB color, like that returned by rgb() e.g. "red" or "#078E53"}

\item{sidecol}{The color of the sides of the bar. Text description or a hexadecimal RGB color, like that returned by rgb() e.g. "gray" or "#aaaaaa"}

\item{linecol}{The color of the edges of the bar. Text description or be a hexadecimal RGB color, like that returned by rgb() e.g. "black" or "#000000"}
}
\value{
Nothing is returned (invisibly returns NULL).
}
\description{
Adds a single 3D bar to the current scene
}
\examples{
\dontshow{
options(rgl.useNULL=TRUE)
}
bar3d(c(0,1),c(0,1),3,alpha=0.6,topcol="#078E53",sidecol="#aaaaaa",linecol="#000000")
}
