% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create-suntimes.R
\name{create_suntimes_rsts}
\alias{create_suntimes_rsts}
\title{Create rasters that indicate sunrise and sunset}
\usage{
create_suntimes_rsts(
  template,
  dates = terra::time(template),
  crs = "EPSG:4258",
  tz = Sys.timezone(),
  .quiet = FALSE
)
}
\arguments{
\item{template}{(Multi-layer) SpatRaster that determines the
spatial extent of the result.}

\item{dates}{Dates that should be processed. If not specified, the dates of
\code{template} are used through \code{\link[terra:time]{terra::time()}}.}

\item{crs}{Coordinate reference system with longitude/latitude metrics.
It is used to project the raster coordinates to be able to retrieve longitude
and latitude.}

\item{tz}{Timezone of the results.}

\item{.quiet}{If \code{TRUE}, messages are suppressed.}
}
\value{
A list with the elements \code{sunrise} and \code{sunset} which are
both multi-layer SpatRasters. The values indicate the respective time in
minutes. Each layer represents one date.
}
\description{
Generate a list of two multi-layer SpatRasters for a given template that
indicate sunrise and sunset for the respective cells.
The package \code{suncalc} is required to use this function.
}
\examples{
\dontshow{if (rlang::is_installed("suncalc")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
# calculate suntimes, use barrks_data()$tmin as template
st <- create_suntimes_rsts(barrks_data()[[1]], .quiet = TRUE)

# plot results on May 1st, 2015
terra::plot(st$sunrise[[terra::time(st$sunrise) == '2015-05-01']])
terra::plot(st$sunset[[terra::time(st$sunset) == '2015-05-01']])
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=create_suntimes_df]{create_suntimes_df()}}
}
