% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BARP_barp.R
\name{barps}
\alias{barps}
\title{Bayesian Additive Regression Trees with Post-stratification (BARP)}
\source{
https://github.com/jbisbee1/BARP
}
\usage{
barps(
  y,
  x,
  dat,
  census,
  geo.unit,
  algorithm = "BARP",
  setSeed = NULL,
  proportion = "None",
  cred_int = c(0.025, 0.975),
  BSSD = FALSE,
  nsims = 200,
  ...
)
}
\arguments{
\item{y}{Outcome of interest. Should be a character of the column name containing the variable of interest.}

\item{x}{Prognostic covariates. Should be a vector of column names corresponding to the covariates used to predict the outcome variable of interest.}

\item{dat}{Survey data containing the x and y column names. The explanatory variables X included in the model must be converted to factors prior to input.}

\item{census}{Census data containing the x column names. It must also have the same structure as X. If the user provides raw census data, BARP will calculate proportions for each unique bin of x covariates. Otherwise, the researcher must calculate bin proportions and indicate the column name that contains the proportions, either as percentages or as raw counts.}

\item{geo.unit}{The column name corresponding to the unit at which outcomes should be aggregated.}

\item{algorithm}{Algorithm for predicting opinions. Can be any algorithm(s) included in the \pkg{SuperLearner} package. If multiple algorithms are listed, predicted opinions are provided for each separately, as well as for the weighted ensemble. Defaults to \code{BARP} which implements Bayesian Additive Regression Trees via \code{bartMachine}.}

\item{setSeed}{Seed to control random number generation.}

\item{proportion}{The column name corresponding to the proportions for covariate bins in the Census data. If left to the default \code{None} value, BARP assumes raw census data and estimates bin proportions automatically.}

\item{cred_int}{A vector giving the lower and upper bounds on the credible interval for the predictions.}

\item{BSSD}{Calculate bootstrapped standard deviation. Defaults to \code{FALSE} in which case the standard deviation is generated by BART's default.}

\item{nsims}{The number of bootstrap simulations.}

\item{...}{Additional arguments to be passed to bartMachine or SuperLearner.}
}
\value{
Returns an object of class `BARP`, containing a list of the following components:
\item{pred.opn}{A \code{data.frame} where each row corresponds to the geographic unit of interest and the columns summarize the predicted outcome and the upper and lower bounds for the given credible interval (\code{cred_int}).}
\item{trees}{A \code{bartMachine} object.} 
\item{risk}{A \code{data.frame} containing the cross-validation risk for each algorithm and the associated weight used in the ensemble predictions. Only useful when multiple algorithms are used.}
\item{barp.dat}{Data containing the estimates and credible intervals for each observation in the input census dataset.}
\item{setSeed}{The random seed value employed during model estimation using bartMachine.}
\item{proportion}{The number of observations in each combination of features.}
\item{x}{The names of the explanatory variables included in the model.}
}
\description{
This function uses Bayesian Additive Regression Trees (BART) to extrapolate survey data to a level of geographic aggregation at which the original survey was not sampled to be representative of.
This is a modified version of the \code{barp} function from the \pkg{BARP} to allow for seed fixation.(\url{https://github.com/jbisbee1/BARP})
}
\seealso{
\code{barps} is used to implement Bayesian Additive Regression Trees based on the \pkg{bartMachine} package. 
For detailed options, see \url{https://CRAN.R-project.org/package=bartMachine}.

\code{barps} also uses the \pkg{SuperLearner} package to implement alternative regularizers. 
For more details, see \url{https://CRAN.R-project.org/package=SuperLearner}.
}
