% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bestHillModel.R
\name{findBestHillModel}
\alias{findBestHillModel}
\title{Selects a best-fitting Hill model given defaults}
\usage{
findBestHillModel(
  conc,
  act,
  defaults,
  start = NULL,
  direction = 0,
  lower = NULL,
  upper = NULL,
  useBIC = TRUE
)
}
\arguments{
\item{conc}{A vector concentration values (including 0 or Inf)}

\item{act}{A vector response values the same length as \code{conc}}

\item{defaults}{A two value numeric vector containing the default minimal
effect and the default maximal effect, in that order}

\item{start}{A vector of four starting values for the Hill model to be fit.
Any values not being fit will be fixed at these starting values.  If left as
\code{NULL}, a starting vector will be estimated from the data.}

\item{direction}{Determines the possible directionality of the dose response
model.  If 0 (the default) no additional constraints are placed on the
parameters.  If greater than 0, the fitting will require that the maximal
effect is \emph{greater} than the minimal effect.  If less than 0, the fitting
wll require tha the maximal effect is \emph{less} than the minimal effect.}

\item{lower}{A length-four vector of lower bounds on the Hill parameter
values.  Any parameters for which you do not wish to specify a bound can be
set to \code{NA}.}

\item{upper}{A vector of upper bounds on the Hill parameter values.  Works
the same as parameter \code{lower}.}

\item{useBIC}{Determines the information criterion to be used.  If \code{TRUE}
(the default), uses the Bayesian information criterion.  If \code{FALSE}, uses
the Akaike information criterion}
}
\value{
An object of class \code{hillrm}.  Contains all of the values found in
any \code{hillrm} object (see \code{\link[=fitHillModel]{fitHillModel()}}), as well as \code{allfits}, a named
list of lists containing the \code{coefficients} and \code{par}vectors for each of the
individual fits, as well as the Bayesian information criterion (\code{bic}) and
Akaike informtion criterion (\code{aic}) values for each fit.
}
\description{
Using the function \code{\link[=fitHillModel]{fitHillModel()}}, this function fits four Hill models
with minimal and maximal effects either varying or fixed at the given
default values; it then selects the best fitting model based on the Bayesian
information criterio or Akaike information criterion, and returns a Hill fit
object with information from all fits included.
}
\examples{
conc <- c(0,2^(-6:3),Inf)
hpar <- c(1,3,0,75)
response <- evalHillModel(conc, hpar) + rnorm(length(conc),sd=7.5)

hfit <- findBestHillModel(conc,response,c(1,2,3,4),defaults=c(0,100))
}
