% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is-clean.R
\name{batch_is_clean}
\alias{batch_is_clean}
\title{Is Clean}
\usage{
batch_is_clean(path, recurse = FALSE)
}
\arguments{
\item{path}{A string of the path to the directory with the files for processing.}

\item{recurse}{A flag specifying whether to recurse into path's subdirectories.}
}
\value{
A flag specifying whether the directory is clean.
}
\description{
Tests whether directory contains configuration file created by \code{\link[=batch_config]{batch_config()}}.
}
\examples{
path <- tempdir()
batch_is_clean(path)
write.csv(mtcars, file.path(path, "file1.csv"))
batch_config(function(x) TRUE, path, regexp = "[.]csv$")
batch_is_clean(path)
batch_cleanup(path, force = TRUE, remaining = TRUE)
batch_is_clean(path)
unlink(file.path(path, "file1.csv"))
}
\seealso{
\code{\link[=batch_cleanup]{batch_cleanup()}}
}
