% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllMethods.R
\name{loo_compare_bgam}
\alias{loo_compare_bgam}
\alias{loo_compare_bgam,bayesGAMfit-method}
\title{Calls the \code{loo} package to compare models fit by \code{bayesGAMfit}}
\usage{
loo_compare_bgam(object, ...)

\S4method{loo_compare_bgam}{bayesGAMfit}(object, ...)
}
\arguments{
\item{object}{Object of type \code{bayesGAMfit} generated from \code{bayesGAM}.}

\item{...}{Additional objects of type \code{bayesGAMfit}}
}
\value{
a matrix with class \code{compare.loo} that has its own print method from the \code{loo} package
}
\description{
Compares fitted models based on ELPD, the expected log pointwise predictive
density for a new dataset.
}
\examples{
f1 <- bayesGAM(weight ~ height, data = women,
              family = gaussian, iter=500, chains = 1)
f2 <- bayesGAM(weight ~ np(height), data=women, 
              family = gaussian, iter=500, chains = 1)
loo_compare_bgam(f1, f2)
}
\references{
Watanabe, S. (2010). Asymptotic equivalence of Bayes cross validation and widely application information criterion in singular learning theory. Journal of Machine Learning Research 11, 3571-3594.

Vehtari, A., Gelman, A., and Gabry, J. (2017a). Practical Bayesian model evaluation using leave-one-out cross-validation and WAIC. Statistics and Computing. 27(5), 1413–1432. doi:10.1007/s11222-016-9696-4 (journal version, preprint arXiv:1507.04544).

Vehtari, A., Gelman, A., and Gabry, J. (2017b). Pareto smoothed importance sampling. preprint arXiv:1507.02646

Vehtari A, Gabry J, Magnusson M, Yao Y, Gelman A (2019). “loo: Efficient leave-one-out cross-validation and WAIC for Bayesian models.” R package version 2.2.0, <URL: https://mc-stan.org/loo>.

Gabry, J. , Simpson, D. , Vehtari, A. , Betancourt, M. and Gelman, A. (2019), Visualization in Bayesian workflow. J. R. Stat. Soc. A, 182: 389-402. doi:10.1111/rssa.12378
}
