% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmcPotts.R
\name{mcmcPotts}
\alias{mcmcPotts}
\title{Fit the hidden Potts model using a Markov chain Monte Carlo algorithm.}
\usage{
mcmcPotts(y, neighbors, blocks, slices, niter = 55000, nburn = 5000,
  priors = NULL, mh = list(algorithm = "pseudolikelihood", bandwidth = 0.2),
  truth = NULL)
}
\arguments{
\item{y}{A vector of observed pixel data.}

\item{neighbors}{A matrix of all neighbors in the lattice, one row per pixel.}

\item{blocks}{A list of pixel indices, dividing the lattice into independent blocks.}

\item{slices}{Deprecated.}

\item{niter}{The number of iterations of the algorithm to perform.}

\item{nburn}{The number of iterations to discard as burn-in.}

\item{priors}{A list of priors for the parameters of the model.}

\item{mh}{A list of options for the Metropolis-Hastings algorithm.}

\item{truth}{A matrix containing the ground truth for the pixel labels.}
}
\value{
A matrix containing MCMC samples for the parameters of the Potts model.
}
\description{
Fit the hidden Potts model using a Markov chain Monte Carlo algorithm.
}
\seealso{
\code{\link[mritc]{mritc.bayes}}
}

