% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lopodDens.R
\name{lopodDens}
\alias{lopodDens}
\title{Kernel density estimates of global occupancy model parameters.}
\usage{
lopodDens(LopodModel, params = NULL)
}
\arguments{
\item{LopodModel}{A LopodModel object}

\item{params}{Parameters to be plotted. Default is NULL, which plots all global parameters}
}
\value{
A ggplot object.
}
\description{
Kernel density estimates of global occupancy model parameters.
}
\examples{

\dontrun{
data("simSpRecords", package = "bayesLopod")
data("simSpSamplingEffort", package = "bayesLopod")
simSpRasters = xyToRaster(xyRecords = simSpRecords,xySamplingEffort = simSpSamplingEffort,
basemap = NULL, nrows = 50, extentExpansion = 0)
ld_Raster_adMatrix = rasterLopodData(rasterN = simSpRasters[["samplingEffort"]],
rasterY = simSpRasters[["spDetections"]], Adjacency = TRUE )
mLopodRaster = modelLopod(LopodData = ld_Raster_adMatrix, varP = TRUE, q = NULL,
pmin = 0.1, CAR = FALSE, nChains = 4,warmup = 500,sampling = 100,nCores = 4)
lopodDens(mLopodRaster, c("alpha", "tau"))

data("Andropogon_shape", package = "bayesLopod")
ld_Shape = shapeLopodData(Shapefile = Andropogon_shape, fieldN = "sampEffort",
fieldY = "detections",  Adjacency = TRUE, keepFields = FALSE)
mLopodShape = modelLopod(LopodData = ld_Shape, varP = TRUE, q = NULL,
pmin = 0, CAR = TRUE, nChains = 4,warmup = 500,sampling = 100,nCores =4)
lopodDens(mLopodShape, c("q", "pmin", "pmax"))
}
}
