% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stan_models.R
\name{stan_garch}
\alias{stan_garch}
\title{Fitting for a GARCH(s,k,h) model.}
\usage{
stan_garch(
  ts,
  order = c(1, 1, 0),
  arma = c(0, 0),
  xreg = NULL,
  genT = FALSE,
  asym = "none",
  chains = 4,
  iter = 4000,
  warmup = floor(iter/2),
  adapt.delta = 0.9,
  tree.depth = 10,
  stepwise = TRUE,
  prior_mu0 = NULL,
  prior_sigma0 = NULL,
  prior_ar = NULL,
  prior_ma = NULL,
  prior_mgarch = NULL,
  prior_arch = NULL,
  prior_garch = NULL,
  prior_breg = NULL,
  prior_gamma = NULL,
  prior_df = NULL,
  series.name = NULL,
  ...
)
}
\arguments{
\item{ts}{a numeric or ts object with the univariate time series.}

\item{order}{A specification of the garch  model: the three components (s, k, h)
are the arch order, the garch order, and the mgarch order.}

\item{arma}{A specification of the  ARMA model,same as order parameter:  the two
components (p, q) are the AR order,and the  MA order.}

\item{xreg}{Optionally, a numerical matrix of external regressors,
which must have the same number of rows as ts. It should not be a data frame.}

\item{genT}{a boolean value to specify for a generalized t-student garch model.}

\item{asym}{a string value for the asymmetric function for an asymmetric GARCH process. By default
the value \code{"none"} for standard GARCH process. If \code{"logit"} a logistic function
is used for asymmetry, and if \code{"exp"} an exponential function is used.}

\item{chains}{An integer of the number of Markov Chains chains to be run,
by default 4 chains are run.}

\item{iter}{An integer of total iterations per chain including the warm-up,
by default  the number of iterations are 2000.}

\item{warmup}{A positive integer specifying number of warm-up (aka burn-in)
iterations. This also specifies the number of iterations used for step-size
adaptation, so warm-up samples should not be used for inference. The number
of warmup should not be larger than \code{iter} and the default is
\code{iter/2}.}

\item{adapt.delta}{An optional real value between 0 and 1, the thin of the jumps
in a HMC method. By default is 0.9.}

\item{tree.depth}{An integer of the maximum  depth of the trees  evaluated
during each iteration. By default is 10.}

\item{stepwise}{If TRUE, will do stepwise selection (faster). Otherwise, it searches
over all models. Non-stepwise selection can be very slow, especially for seasonal models.}

\item{prior_mu0}{The prior distribution for the location parameter in an ARMA model. By default
the value is set \code{NULL}, then the default normal(0,1) prior is used.}

\item{prior_sigma0}{The prior distribution for the scale parameter in an ARMA model. By default
the value is set \code{NULL}, then the default student(7,0,1) prior is used.}

\item{prior_ar}{The prior distribution for the auto-regressive parameters in an ARMA model.
By default the value is set \code{NULL}, then the default normal(0,0.5) priors are used.}

\item{prior_ma}{The prior distribution for the moving average parameters in an ARMA model.
By default the value is set \code{NULL}, then the default normal(0,0.5) priors are used.}

\item{prior_mgarch}{The prior distribution for the mean GARCH parameters in a
GARCH model. By default the value is set \code{NULL}, then the default normal(0,0.5) priors
are used.}

\item{prior_arch}{The prior distribution for the arch parameters in a GARCH model.
By default the value is set \code{NULL}, then the default normal(0,0.5) priors
are used.}

\item{prior_garch}{The prior distribution for the GARCH parameters in a GARCH model.
By default the value is set \code{NULL}, then the default normal(0,0.5) priors
are used.}

\item{prior_breg}{The prior distribution for the regression coefficient parameters in a
ARIMAX model. By default the value is set \code{NULL}, then the default student(7,0,1) priors
are used.}

\item{prior_gamma}{The prior distribution for the asymmetric parameters in am Asymmetric
GARCH model. By default the value is set \code{NULL}, then the default normal(0,0.5) priors
are used.}

\item{prior_df}{The prior distribution for the degree freedom parameters in a t-student innovations
GARCH model. By default the value is set \code{NULL}, then the default gamma(2,0.1) priors
are used.}

\item{series.name}{an optional string vector with the series names.}

\item{...}{Further arguments passed to  \code{varstan} function.}
}
\value{
A \code{varstan} object with the fitted GARCH model.
}
\description{
Fitting a \code{GARCH(s,k,h)} model in \pkg{Stan}.
}
\details{
The function returns a \code{varstan} object with the fitted model.

By default the \code{garch()} function generates a GARCH(1,1) model, when
\code{genT} option is \code{TRUE} a t-student innovations GARCH model
(see Ardia (2010)) is generated, and for Asymmetric GARCH models use the
option \code{asym} for specify the asymmetric function, see Fonseca,
et. al (2019) for more details.

The default priors used in a GARCH(s,k,h) model are:

\itemize{
\item{ar ~ normal(0,0.5)}
\item{ma ~ normal(0,0.5)}
\item{mu0 ~ t-student(0,2.5,6)}
\item{sigma0 ~ t-student(0,1,7)}
\item{arch ~ normal(0,0.5)}
\item{garch ~ normal(0,0.5)}
\item{mgarch ~ normal(0,0.5)}
\item{dfv ~ gamma(2,0.1)}
\item{breg ~ t-student(0,2.5,6)}
}

For changing the default prior use the function \code{set_prior()}.
}
\examples{
\donttest{
 # Declaring a garch(1,1) model for the ipc data.
 sf1 = stan_garch(ipc,order = c(1,1,0))

 # Declaring a t-student M-GARCH(2,3,1)-ARMA(1,1) process for the ipc data.
 sf2 = stan_garch(ipc,order = c(2,3,1),arma = c(1,1),genT = TRUE)
}

}
\references{
Engle, R. (1982). Autoregressive Conditional Heteroscedasticity with Estimates of
the Variance of United Kingdom Inflation. \emph{Econometrica}, 50(4), 987-1007.
\code{url: http://www.jstor.org/stable/1912773}.

Bollerslev, T. (1986). Generalized autoregressive conditional heteroskedasticity.
\emph{Journal of Econometrics}. 31(3), 307-327.
\code{doi: https://doi.org/10.1016/0304-4076(86)90063-1}.

Fonseca, T. and Cequeira, V. and Migon, H. and Torres, C. (2019). The effects of
degrees of freedom estimation in the Asymmetric GARCH model with Student-t
Innovations. \emph{arXiv} \code{doi: arXiv: 1910.01398}.

Ardia, D. and Hoogerheide, L. (2010). Bayesian Estimation of the GARCH(1,1) Model
with Student-t Innovations. \emph{The R Journal}. 2(7), 41-47.
\code{doi: 10.32614/RJ-2010-014}.
}
\seealso{
\code{\link{Sarima}} \code{\link{auto.arima}} \code{\link{set_prior}}
}
\author{
Asael Alonzo Matamoros.
}
